/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import eqtlmappingpipeline.ase.AseMle;
import eqtlmappingpipeline.ase.AseVariant;
import java.util.ArrayList;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.variant.id.GeneticVariantId;

public class AseVariantBean
implements AseVariant {
    private final String chr;
    private final int pos;
    private final GeneticVariantId id;
    private final Allele a1;
    private final Allele a2;
    private final IntArrayList a1Counts;
    private final IntArrayList a2Counts;
    private final DoubleArrayList pValues;
    private final ArrayList<String> sampleIds;
    private final double metaZscore;
    private final double metaPvalue;
    private final double countPearsonR;
    private double effect;
    private double LikelihoodRatioP;
    private double LikelihoodRatioD;
    private AseMle mle;

    public AseVariantBean(String chr, int pos, GeneticVariantId id, Allele a1, Allele a2, IntArrayList a1Counts, IntArrayList a2Counts, DoubleArrayList pValues, ArrayList<String> sampleIds, double metaZscore, double metaPvalue, double countPearsonR) {
        this.chr = chr;
        this.pos = pos;
        this.id = id;
        this.a1 = a1;
        this.a2 = a2;
        this.a1Counts = a1Counts;
        this.a2Counts = a2Counts;
        this.pValues = pValues;
        this.sampleIds = sampleIds;
        this.metaZscore = metaZscore;
        this.metaPvalue = metaPvalue;
        this.countPearsonR = countPearsonR;
    }

    public AseVariantBean(String[] outputLine) {
        this.effect = Double.parseDouble(outputLine[2]);
        this.LikelihoodRatioP = Double.parseDouble(outputLine[0]);
        this.LikelihoodRatioD = Double.parseDouble(outputLine[1]);
        this.chr = outputLine[5];
        this.pos = Integer.parseInt(outputLine[6]);
        this.id = GeneticVariantId.createVariantId((String)outputLine[7]);
        this.a1 = Allele.create((String)outputLine[9]);
        this.a2 = Allele.create((String)outputLine[10]);
        this.a1Counts = new IntArrayList();
        for (String s : outputLine[13].split(",")) {
            this.a1Counts.add(Integer.parseInt(s));
        }
        this.a2Counts = new IntArrayList();
        for (String s : outputLine[14].split(",")) {
            this.a2Counts.add(Integer.parseInt(s));
        }
        this.pValues = new DoubleArrayList();
        for (String s : outputLine[15].split(",")) {
            this.pValues.add(Double.parseDouble(s));
        }
        this.sampleIds = new ArrayList();
        for (String s : outputLine[15].split(",")) {
            this.sampleIds.add(s);
        }
        this.metaZscore = Double.parseDouble(outputLine[4]);
        this.metaPvalue = Double.parseDouble(outputLine[3]);
        this.countPearsonR = Double.parseDouble(outputLine[11]);
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public GeneticVariantId getId() {
        return this.id;
    }

    @Override
    public Allele getA1() {
        return this.a1;
    }

    @Override
    public Allele getA2() {
        return this.a2;
    }

    @Override
    public IntArrayList getA1Counts() {
        return this.a1Counts;
    }

    @Override
    public IntArrayList getA2Counts() {
        return this.a2Counts;
    }

    @Override
    public DoubleArrayList getPValues() {
        return this.pValues;
    }

    @Override
    public ArrayList<String> getSampleIds() {
        return this.sampleIds;
    }

    @Override
    public double getMetaZscore() {
        return this.metaZscore;
    }

    @Override
    public double getMetaPvalue() {
        return this.metaPvalue;
    }

    @Override
    public double getCountPearsonR() {
        return this.countPearsonR;
    }

    @Override
    public AseMle getMle() {
        return this.mle;
    }

    @Override
    public int getSampleCount() {
        return this.a1Counts.size();
    }

    @Override
    public int compareTo(AseVariant o) {
        double thisRatioD = this.getMle().getRatioD();
        double otherRatioD = o.getMle().getRatioD();
        return Double.compare(otherRatioD, thisRatioD);
    }

    public DoubleArrayList getpValues() {
        return this.pValues;
    }

    public double getEffect() {
        return this.effect;
    }

    public double getLikelihoodRatioP() {
        return this.LikelihoodRatioP;
    }

    public double getLikelihoodRatioD() {
        return this.LikelihoodRatioD;
    }
}

