/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.stat.tdouble.Probability;
import eqtlmappingpipeline.ase.AseMle;
import eqtlmappingpipeline.ase.AseVariant;
import java.util.ArrayList;
import org.apache.commons.math3.stat.inference.AlternativeHypothesis;
import org.apache.commons.math3.stat.inference.BinomialTest;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.variant.id.GeneticVariantId;

public class AseVariantAppendable
implements AseVariant {
    private final String chr;
    private final int pos;
    private final GeneticVariantId id;
    private final Allele a1;
    private final Allele a2;
    private final IntArrayList a1Counts;
    private final IntArrayList a2Counts;
    private final DoubleArrayList pValues;
    private final ArrayList<String> sampleIds;
    private double metaZscore;
    private double metaPvalue;
    private double countPearsonR;
    private AseMle mle;
    private static final BinomialTest btest = new BinomialTest();
    private static final double LARGEST_ZSCORE = Probability.normalInverse((double)Double.MIN_NORMAL);

    public AseVariantAppendable(String chr, int pos, GeneticVariantId id, Allele a1, Allele a2) {
        this.chr = chr;
        this.pos = pos;
        this.id = id;
        this.a1 = a1;
        this.a2 = a2;
        this.a1Counts = new IntArrayList();
        this.a2Counts = new IntArrayList();
        this.pValues = new DoubleArrayList();
        this.sampleIds = new ArrayList();
        this.metaZscore = Double.NaN;
        this.metaPvalue = Double.NaN;
        this.countPearsonR = Double.NaN;
        this.mle = null;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public GeneticVariantId getId() {
        return this.id;
    }

    @Override
    public Allele getA1() {
        return this.a1;
    }

    @Override
    public Allele getA2() {
        return this.a2;
    }

    @Override
    public IntArrayList getA1Counts() {
        return this.a1Counts;
    }

    @Override
    public IntArrayList getA2Counts() {
        return this.a2Counts;
    }

    public void calculateStatistics() {
        double zscoreSum = 0.0;
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < this.a1Counts.size(); ++i) {
            regression.addData((double)this.a1Counts.getQuick(i), (double)this.a2Counts.getQuick(i));
            double pvalue = this.pValues.getQuick(i);
            double pvalueDiv2 = pvalue / 2.0;
            double zscore = pvalueDiv2 < Double.MIN_NORMAL ? LARGEST_ZSCORE : Probability.normalInverse((double)pvalueDiv2);
            if (this.a1Counts.getQuick(i) < this.a2Counts.getQuick(i)) {
                zscoreSum -= zscore;
                continue;
            }
            zscoreSum += zscore;
        }
        this.countPearsonR = regression.getR();
        this.metaZscore = zscoreSum / Math.sqrt(this.a1Counts.size());
        this.metaPvalue = 2.0 * Probability.normal((double)(-Math.abs(this.metaZscore)));
        this.mle = new AseMle(this.a1Counts, this.a2Counts);
    }

    @Override
    public double getMetaZscore() {
        if (Double.isNaN(this.metaZscore)) {
            this.calculateStatistics();
        }
        return this.metaZscore;
    }

    @Override
    public double getMetaPvalue() {
        if (Double.isNaN(this.metaZscore)) {
            this.calculateStatistics();
        }
        return this.metaPvalue;
    }

    public synchronized void addCounts(int a1Count, int a2Count, String sampleId) {
        this.addCounts(a1Count, a2Count, sampleId, Double.NaN, Double.NaN);
    }

    public synchronized void addCounts(int a1Count, int a2Count, String sampleId, double a1MeanBaseQuality, double a2MeanBaseQuality) {
        this.metaZscore = Double.NaN;
        this.metaPvalue = Double.NaN;
        this.countPearsonR = Double.NaN;
        this.mle = null;
        this.a1Counts.add(a1Count);
        this.a2Counts.add(a2Count);
        this.pValues.add(btest.binomialTest(a1Count + a2Count, a1Count, 0.5, AlternativeHypothesis.TWO_SIDED));
        this.sampleIds.add(sampleId);
    }

    @Override
    public int compareTo(AseVariant o) {
        double thisRatioD = this.getMle().getRatioD();
        double otherRatioD = o.getMle().getRatioD();
        return Double.compare(otherRatioD, thisRatioD);
    }

    @Override
    public int getSampleCount() {
        return this.a1Counts.size();
    }

    @Override
    public double getCountPearsonR() {
        if (Double.isNaN(this.countPearsonR)) {
            this.calculateStatistics();
        }
        return this.countPearsonR;
    }

    @Override
    public ArrayList<String> getSampleIds() {
        return this.sampleIds;
    }

    @Override
    public DoubleArrayList getPValues() {
        return this.pValues;
    }

    @Override
    public AseMle getMle() {
        if (this.mle == null) {
            this.calculateStatistics();
        }
        return this.mle;
    }
}

