/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import eqtlmappingpipeline.ase.AseVariantAppendable;
import java.util.Iterator;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import umcg.genetica.collections.ChrPosMap;

public class AseResults
implements Iterable<AseVariantAppendable> {
    private final ChrPosMap<AseVariantAppendable> results = new ChrPosMap();
    private boolean encounteredBaseQuality = false;

    public synchronized void addResult(String chr, int pos, GeneticVariantId id, Allele a1, Allele a2, int a1Count, int a2Count, String sampleId, double a1MeanBaseQuality, double a2MeanBaseQuality) {
        this.addToResults(chr, pos, id, a1, a2, a1Count, a2Count, sampleId, a1MeanBaseQuality, a2MeanBaseQuality);
        this.encounteredBaseQuality = true;
    }

    public synchronized void addResult(String chr, int pos, GeneticVariantId id, Allele a1, Allele a2, int a1Count, int a2Count, String sampleId) {
        this.addToResults(chr, pos, id, a1, a2, a1Count, a2Count, sampleId, Double.NaN, Double.NaN);
    }

    private synchronized void addToResults(String chr, int pos, GeneticVariantId id, Allele a1, Allele a2, int a1Count, int a2Count, String sampleId, double a1MeanBaseQuality, double a2MeanBaseQuality) {
        AseVariantAppendable aseVariant = this.results.get(chr, pos);
        if (aseVariant == null) {
            aseVariant = new AseVariantAppendable(chr, pos, id, a1, a2);
            this.results.put(chr, pos, aseVariant);
        }
        aseVariant.addCounts(a1Count, a2Count, sampleId, a1MeanBaseQuality, a2MeanBaseQuality);
    }

    public Iterator<AseVariantAppendable> chrIterator(String chr) {
        return this.results.chrIterator(chr);
    }

    @Override
    public Iterator<AseVariantAppendable> iterator() {
        return this.results.iterator();
    }

    public boolean isEncounteredBaseQuality() {
        return this.encounteredBaseQuality;
    }

    public int getCount() {
        return this.results.size();
    }
}

