/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import cern.colt.list.tint.IntArrayList;
import cern.jet.stat.tdouble.Probability;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.log4j.Logger;

public class AseMle {
    private final double maxLogLikelihoodP;
    private final double maxLogLikelihood;
    private final double ratioD;
    private final double ratioP;
    private static final double[] cof;
    private static final double[] a;
    private static final int NTOP = 2000;
    private static final double[] aa;
    private static final Logger LOGGER;
    private static final BigDecimal probabilityStep;
    private static final MathContext mathContextProbability;
    protected static final double[] probabilities;
    protected static final double[] logProbabilities;
    protected static final double[] log1minProbabilities;

    public AseMle(IntArrayList a1Counts, IntArrayList a2Counts) {
        double provisionalMaxLogLikelihood = Double.NEGATIVE_INFINITY;
        double provisionalMaxLogLikelihoodP = 0.5;
        double[] logBinominalCoefficients = new double[a1Counts.size()];
        for (int i = 0; i < a1Counts.size(); ++i) {
            int a1Count = a1Counts.getQuick(i);
            int totalReads = a1Count + a2Counts.getQuick(i);
            logBinominalCoefficients[i] = AseMle.lnbico(totalReads, a1Count);
        }
        double logLikelihoodNull = Double.NaN;
        for (int i = 0; i < probabilities.length; ++i) {
            double sumLogLikelihood = 0.0;
            for (int s = 0; s < a1Counts.size(); ++s) {
                sumLogLikelihood += logBinominalCoefficients[s] + (double)a1Counts.getQuick(s) * logProbabilities[i] + (double)a2Counts.getQuick(s) * log1minProbabilities[i];
            }
            if (sumLogLikelihood > provisionalMaxLogLikelihood) {
                provisionalMaxLogLikelihood = sumLogLikelihood;
                provisionalMaxLogLikelihoodP = probabilities[i];
            }
            if (probabilities[i] != 0.5) continue;
            logLikelihoodNull = sumLogLikelihood;
        }
        if (Double.isNaN(logLikelihoodNull)) {
            throw new RuntimeException("Something went wrong during ASE analysis. This should nog happen, please contact developers");
        }
        if (logLikelihoodNull >= provisionalMaxLogLikelihood) {
            this.maxLogLikelihood = logLikelihoodNull;
            this.maxLogLikelihoodP = 0.5;
            this.ratioD = 0.0;
            this.ratioP = 1.0;
        } else {
            this.maxLogLikelihood = provisionalMaxLogLikelihood;
            this.maxLogLikelihoodP = provisionalMaxLogLikelihoodP;
            double ratioD2 = -2.0 * logLikelihoodNull + 2.0 * this.maxLogLikelihood;
            this.ratioD = ratioD2 < 0.0 ? 0.0 : ratioD2;
            this.ratioP = Probability.chiSquareComplemented((double)1.0, (double)this.ratioD);
            if (Double.isInfinite(this.ratioD) || Double.isNaN(this.ratioD)) {
                LOGGER.warn((Object)("Warning invalid ratio D: " + ratioD2 + ". max log likelihood: " + this.maxLogLikelihood + " null log likelihood: " + logLikelihoodNull + " max log likelihood p: " + this.maxLogLikelihoodP));
            }
        }
    }

    public double getMaxLikelihood() {
        return this.maxLogLikelihood;
    }

    public double getMaxLikelihoodP() {
        return this.maxLogLikelihoodP;
    }

    public double getRatioD() {
        return this.ratioD;
    }

    public double getRatioP() {
        return this.ratioP;
    }

    private static double gammln(double xx) {
        double x;
        if (xx <= 0.0) {
            throw new IllegalArgumentException("bad arg in gammln");
        }
        double y = x = xx;
        double tmp = x + 5.2421875;
        tmp = (x + 0.5) * Math.log(tmp) - tmp;
        double ser = 0.9999999999999971;
        for (int j = 0; j < 14; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return tmp + Math.log(2.5066282746310007 * ser / x);
    }

    private static double factrl(int n) {
        if (n < 0 || n > 170) {
            throw new IllegalArgumentException("factrl out of range");
        }
        return a[n];
    }

    private static double factln(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative arg in factln");
        }
        if (n < 2000) {
            return aa[n];
        }
        return AseMle.gammln((double)n + 1.0);
    }

    protected static double bico(int n, int k) {
        if (n < 0 || k < 0 || k > n) {
            throw new IllegalArgumentException("bad args in bico");
        }
        if (n < 171) {
            return Math.floor(0.5 + AseMle.factrl(n) / (AseMle.factrl(k) * AseMle.factrl(n - k)));
        }
        return Math.floor(0.5 + Math.exp(AseMle.factln(n) - AseMle.factln(k) - AseMle.factln(n - k)));
    }

    protected static double lnbico(int n, int k) {
        if (n < 0 || k < 0 || k > n) {
            throw new IllegalArgumentException("bad args in bico");
        }
        if (n < 171) {
            return Math.log(Math.floor(0.5 + AseMle.factrl(n) / (AseMle.factrl(k) * AseMle.factrl(n - k))));
        }
        return AseMle.factln(n) - AseMle.factln(k) - AseMle.factln(n - k);
    }

    static {
        int i;
        cof = new double[]{57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        a = new double[171];
        aa = new double[2000];
        LOGGER = Logger.getLogger(AseMle.class);
        probabilityStep = new BigDecimal(0.001);
        mathContextProbability = new MathContext(3, RoundingMode.HALF_UP);
        AseMle.a[0] = 1.0;
        for (i = 1; i < 171; ++i) {
            AseMle.a[i] = (double)i * a[i - 1];
        }
        for (i = 0; i < 2000; ++i) {
            AseMle.aa[i] = AseMle.gammln((double)i + 1.0);
        }
        BigDecimal one = new BigDecimal(1);
        int stepCount = (int)(1.0 / probabilityStep.doubleValue()) - 1;
        probabilities = new double[stepCount];
        logProbabilities = new double[stepCount];
        log1minProbabilities = new double[stepCount];
        int i2 = 0;
        BigDecimal p = probabilityStep;
        while (p.compareTo(one) < 0) {
            double p2;
            AseMle.probabilities[i2] = p2 = p.round(mathContextProbability).doubleValue();
            AseMle.logProbabilities[i2] = Math.log(p2);
            AseMle.log1minProbabilities[i2] = Math.log(1.0 - p2);
            ++i2;
            p = p.add(probabilityStep);
        }
    }
}

