/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import eqtlmappingpipeline.ase.Ase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;

public class AseConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AseConfiguration.class);
    private static final Options OPTIONS = new Options();
    public static final String ENCODING = "UTF-8";
    private final List<File> inputFiles;
    private final File outputFolder;
    private final int minTotalReads;
    private final int minAlleleReads;
    private final double minAlleleReadFraction;
    private final File logFile;
    private final boolean debugMode;
    private final int minSamples;
    private final int threads;
    private final String[] refBasePaths;
    private final RandomAccessGenotypeDataReaderFormats refDataType;
    private final int refDataCacheSize;
    private final int maxTotalReads;
    private final File gtf;
    private final File sampleToRefSampleFile;
    private final String chrFilter;
    private final int chunkSize;
    private final File mappabilityTrackFile;
    private final double mappabilityMinimum;

    public AseConfiguration(String ... args) throws ParseException {
        CommandLine commandLine;
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            commandLine = new PosixParser().parse(OPTIONS, args, true);
                            if (!commandLine.hasOption('i') && !commandLine.hasOption('l')) {
                                throw new ParseException("At least --input or --inputList need to be supplied");
                            }
                            ArrayList<File> inputFilesTmp = new ArrayList<File>();
                            if (commandLine.hasOption('i')) {
                                String[] inputPaths;
                                for (String inputPath : inputPaths = commandLine.getOptionValues('i')) {
                                    inputFilesTmp.add(new File(inputPath));
                                }
                            }
                            if (commandLine.hasOption('l')) {
                                String[] inputListFilePaths;
                                for (String inputListFilePath : inputListFilePaths = commandLine.getOptionValues('l')) {
                                    try {
                                        String line;
                                        BufferedReader inputListFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputListFilePath), ENCODING));
                                        while ((line = inputListFileReader.readLine()) != null) {
                                            inputFilesTmp.add(new File(line));
                                        }
                                    }
                                    catch (FileNotFoundException ex) {
                                        throw new ParseException("Could not find file with list of input files: " + inputListFilePath);
                                    }
                                    catch (UnsupportedEncodingException ex) {
                                        throw new RuntimeException("Fatal error", ex);
                                    }
                                    catch (IOException ex) {
                                        throw new ParseException("Error reading list of input files: " + inputListFilePath);
                                    }
                                }
                            }
                            this.inputFiles = Collections.unmodifiableList(inputFilesTmp);
                            this.outputFolder = new File(commandLine.getOptionValue('o'));
                            this.logFile = new File(this.outputFolder, "ase.log");
                            try {
                                this.minTotalReads = Integer.parseInt(commandLine.getOptionValue('r'));
                                if (this.minTotalReads <= 0) {
                                    throw new ParseException("--minReads must be larger than 0");
                                }
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("Error parsing --minReads \"" + commandLine.getOptionValue('r') + "\" is not an int");
                            }
                            try {
                                this.minAlleleReads = Integer.parseInt(commandLine.getOptionValue('a'));
                                if (this.minAlleleReads < 0) {
                                    throw new ParseException("--minAlleleReads must be positive");
                                }
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("Error parsing --minAlleleReads \"" + commandLine.getOptionValue('a') + "\" is not an int");
                            }
                            if (commandLine.hasOption('p')) {
                                try {
                                    this.minAlleleReadFraction = Double.parseDouble(commandLine.getOptionValue('p')) / 100.0;
                                    if (this.minAlleleReadFraction < 0.0 || this.minAlleleReadFraction >= 0.5) {
                                        throw new ParseException("--minAllelePercentage must be in interval [0, 50)");
                                    }
                                    break block55;
                                }
                                catch (NumberFormatException e) {
                                    throw new ParseException("Error parsing --minAllelePercentage \"" + commandLine.getOptionValue('p') + "\" is not a double");
                                }
                            }
                            this.minAlleleReadFraction = 0.0;
                        }
                        try {
                            this.minSamples = Integer.parseInt(commandLine.getOptionValue('s'));
                            if (this.minSamples <= 0) {
                                throw new ParseException("--minNumSamples must be larger than 0");
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Error parsing --minNumSamples \"" + commandLine.getOptionValue('s') + "\" is not an int");
                        }
                        int availCores = Runtime.getRuntime().availableProcessors();
                        if (commandLine.hasOption('t')) {
                            try {
                                int threadOption = Integer.parseInt(commandLine.getOptionValue('t'));
                                if (threadOption <= 0) {
                                    throw new ParseException("--threads must be larger than 0");
                                }
                                this.threads = threadOption > availCores ? availCores : threadOption;
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("Error parsing --threads \"" + commandLine.getOptionValue('t') + "\" is not an int");
                            }
                        } else {
                            this.threads = availCores;
                        }
                        if (commandLine.hasOption('c')) {
                            try {
                                this.refDataCacheSize = Integer.parseInt(commandLine.getOptionValue('c'));
                                if (this.refDataCacheSize < 0) {
                                    throw new ParseException("--cache must be positive");
                                }
                                break block56;
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("Error parsing --cache \"" + commandLine.getOptionValue('c') + "\" is not an int");
                            }
                        }
                        this.refDataCacheSize = 1000;
                    }
                    if (commandLine.hasOption('g')) {
                        this.refBasePaths = commandLine.getOptionValues('g');
                        try {
                            if (commandLine.hasOption('G')) {
                                this.refDataType = RandomAccessGenotypeDataReaderFormats.valueOf((String)commandLine.getOptionValue('G').toUpperCase());
                            }
                            if (this.refBasePaths[0].endsWith(".vcf")) {
                                throw new ParseException("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                            }
                            try {
                                this.refDataType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath((String[])new String[]{this.refBasePaths[0]});
                            }
                            catch (GenotypeDataException e) {
                                throw new ParseException("Unable to determine reference data type based on specified path. Please specify --genotypesType");
                            }
                        }
                        catch (IllegalArgumentException e) {
                            throw new ParseException("Error parsing --genotypesType \"" + commandLine.getOptionValue('G') + "\" is not a valid input data format");
                        }
                    } else {
                        this.refBasePaths = null;
                        this.refDataType = null;
                    }
                    if (commandLine.hasOption('m')) {
                        try {
                            this.maxTotalReads = Integer.parseInt(commandLine.getOptionValue('m'));
                            if (this.maxTotalReads <= 0) {
                                throw new ParseException("--maxReads must be larger than 0");
                            }
                            break block57;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Error parsing --maxReads \"" + commandLine.getOptionValue('m') + "\" is not an int");
                        }
                    }
                    this.maxTotalReads = Integer.MAX_VALUE;
                }
                if (commandLine.hasOption('f')) {
                    String gencodeGtfPath = commandLine.getOptionValue('f');
                    this.gtf = new File(gencodeGtfPath);
                } else {
                    this.gtf = null;
                }
                this.sampleToRefSampleFile = commandLine.hasOption("sc") ? new File(commandLine.getOptionValue("sc")) : null;
                String string = this.chrFilter = commandLine.hasOption("ch") ? commandLine.getOptionValue("ch") : null;
                if (commandLine.hasOption("cs")) {
                    try {
                        this.chunkSize = Integer.parseInt(commandLine.getOptionValue("cs")) * 1000000;
                        if (this.chunkSize <= 0) {
                            throw new ParseException("--chunkSize must be larger than 0");
                        }
                        break block58;
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Error parsing --chunkSize \"" + commandLine.getOptionValue("cs") + "\" is not an int");
                    }
                }
                this.chunkSize = Integer.MAX_VALUE;
            }
            if (commandLine.hasOption("mt")) {
                if (!commandLine.hasOption("mm")) {
                    throw new ParseException("--mappabilityTrack is set but --mappabilityMinimum is not");
                }
                this.mappabilityTrackFile = new File(commandLine.getOptionValue("mt"));
                try {
                    this.mappabilityMinimum = Integer.parseInt(commandLine.getOptionValue("mm"));
                    if (this.mappabilityMinimum < 0.0 || this.mappabilityMinimum > 1.0) {
                        throw new ParseException("--mappabilityMinimum must be between 0 and 1");
                    }
                    break block59;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Error parsing --mappabilityMinimum \"" + commandLine.getOptionValue("mm") + "\" is not a double");
                }
            }
            this.mappabilityTrackFile = null;
            this.mappabilityMinimum = 0.0;
        }
        this.debugMode = commandLine.hasOption('d');
    }

    public void printOptions() {
        System.out.println("Interpreted arguments: ");
        System.out.println(" - Input files or folders (" + Ase.DEFAULT_NUMBER_FORMATTER.format(this.inputFiles.size()) + " in total): ");
        if (this.inputFiles.size() > 5) {
            System.out.println("  * Reading more than 5 files. See log file for list.");
        } else {
            for (File inputFile : this.inputFiles) {
                System.out.println("  * " + inputFile.getAbsolutePath());
            }
        }
        LOGGER.info((Object)("Input files or folders (" + Ase.DEFAULT_NUMBER_FORMATTER.format(this.inputFiles.size()) + " in total): "));
        for (File inputFile : this.inputFiles) {
            LOGGER.info((Object)(" * " + inputFile.getAbsolutePath()));
        }
        System.out.println(" - Output folder: " + this.outputFolder.getAbsolutePath());
        LOGGER.info((Object)("Output folder: " + this.outputFolder.getAbsolutePath()));
        System.out.println(" - Minimum number of reads per genotype: " + this.minTotalReads);
        LOGGER.info((Object)("Minimum number of reads per genotype: " + this.minTotalReads));
        System.out.println(" - Minimum number of reads per allele: " + this.minAlleleReads);
        LOGGER.info((Object)("Minimum number of reads per allele: " + this.minAlleleReads));
        System.out.println(" - Minimum percentage of reads per allele: " + this.minAlleleReadFraction * 100.0 + "%");
        LOGGER.info((Object)("Minimum percentage of reads per allele: " + this.minAlleleReadFraction * 100.0 + "%"));
        if (this.maxTotalReads != Integer.MAX_VALUE) {
            System.out.println(" - Maximum number of reads per genotype: " + this.maxTotalReads);
            LOGGER.info((Object)("Maximum number of reads per genotype: " + this.maxTotalReads));
        }
        System.out.println(" - Minimum number of samples per ASE effect: " + this.minSamples);
        LOGGER.info((Object)("Minimum number of samples per ASE effect: " + this.minSamples));
        System.out.println(" - Number of threads to use: " + this.threads);
        LOGGER.info((Object)("Number of threads to use: " + this.threads));
        if (this.chrFilter != null) {
            System.out.println(" - Confine analysis to chr: " + this.chrFilter);
            LOGGER.info((Object)("Confine analysis to chr: " + this.chrFilter));
        }
        if (this.isRefSet()) {
            System.out.print(" - Reference genotypes " + this.refDataType.getName() + ":");
            LOGGER.info((Object)("Reference genotypes " + this.refDataType.getName() + ":"));
            for (String path : this.refBasePaths) {
                System.out.print(" " + path);
                LOGGER.info((Object)(" " + path));
            }
            System.out.println();
            System.out.println(" - Reference genotype cache size: " + Ase.DEFAULT_NUMBER_FORMATTER.format(this.refDataCacheSize));
            LOGGER.info((Object)("Reference genotype cache size: " + Ase.DEFAULT_NUMBER_FORMATTER.format(this.refDataCacheSize)));
            if (this.isSampleToRefSampleFileSet()) {
                System.out.println(" - Sample mapping to reference file: " + this.sampleToRefSampleFile.getAbsolutePath());
                LOGGER.info((Object)("Sample mapping to reference file: " + this.sampleToRefSampleFile.getAbsolutePath()));
            }
        }
        if (this.isGtfSet()) {
            System.out.println(" - GTF file: " + this.gtf.getAbsolutePath());
            LOGGER.info((Object)("GTF file: " + this.gtf.getAbsolutePath()));
        }
        if (this.chunkSize != Integer.MAX_VALUE) {
            System.out.println(" - Chunk size: " + Ase.DEFAULT_NUMBER_FORMATTER.format(this.chunkSize));
            LOGGER.info((Object)("Chunk size: " + Ase.DEFAULT_NUMBER_FORMATTER.format(this.chunkSize)));
        }
        if (this.isMappabilityTrackSet()) {
            System.out.println(" - Mappability track: " + this.mappabilityTrackFile.getAbsolutePath());
            LOGGER.info((Object)("Mappability track: " + this.mappabilityTrackFile.getAbsolutePath()));
            System.out.println(" - Mappability minimum: " + this.mappabilityMinimum);
            LOGGER.info((Object)("Mappability mimimum: " + this.mappabilityMinimum));
        }
        System.out.println();
        System.out.flush();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void printHelp() {
        new HelpFormatter().printHelp(" ", OPTIONS);
    }

    public List<File> getInputFiles() {
        return this.inputFiles;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public int getMinTotalReads() {
        return this.minTotalReads;
    }

    public int getMinAlleleReads() {
        return this.minAlleleReads;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public int getMinSamples() {
        return this.minSamples;
    }

    public int getThreads() {
        return this.threads;
    }

    public String[] getRefBasePaths() {
        return this.refBasePaths;
    }

    public RandomAccessGenotypeDataReaderFormats getRefDataType() {
        return this.refDataType;
    }

    public boolean isRefSet() {
        return this.refBasePaths != null;
    }

    public int getRefDataCacheSize() {
        return this.refDataCacheSize;
    }

    public File getGtf() {
        return this.gtf;
    }

    public int getMaxTotalReads() {
        return this.maxTotalReads;
    }

    public boolean isGtfSet() {
        return this.gtf != null;
    }

    public double getMinAlleleReadFraction() {
        return this.minAlleleReadFraction;
    }

    public File getSampleToRefSampleFile() {
        return this.sampleToRefSampleFile;
    }

    public boolean isSampleToRefSampleFileSet() {
        return this.sampleToRefSampleFile != null;
    }

    public String getChrFilter() {
        return this.chrFilter;
    }

    public boolean isMappabilityTrackSet() {
        return this.mappabilityTrackFile != null;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public File getMappabilityTrackFile() {
        return this.mappabilityTrackFile;
    }

    public double getMappabilityMinimum() {
        return this.mappabilityMinimum;
    }

    static {
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Paths to one or more vcf.gz files or folders with each per chr 1 vcf.gz file. Tabix file must be present");
        OptionBuilder.withLongOpt((String)"input");
        OPTIONS.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"One or more text files with on each line a path to a vcf.gz file or a folder with per chr 1 vcf.gz file. Tabix file must be present. Can be combined with --input");
        OptionBuilder.withLongOpt((String)"inputList");
        OPTIONS.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Path to output folder");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Min number total reads for genotype");
        OptionBuilder.withLongOpt((String)"minReads");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Min number of reads per allele");
        OptionBuilder.withLongOpt((String)"minAlleleReads");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Min percentage of read per allele. Default 0. Can be used in combination --minAlleleReads");
        OptionBuilder.withLongOpt((String)"minAllelePercentage");
        OPTIONS.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Min number of samples per ASE effect");
        OptionBuilder.withLongOpt((String)"minNumSamples");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Maximum number of threads to start for parallel reading of multiple VCF files. Defaults to number of cores");
        OptionBuilder.withLongOpt((String)"threads");
        OPTIONS.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"The path to the reference genotypes. These genotypes will be used to determine if a sample is hetrozygous");
        OptionBuilder.withLongOpt((String)"genotypes");
        OPTIONS.addOption(OptionBuilder.create((String)"g"));
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The input data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt((String)"genotypesType");
        OPTIONS.addOption(OptionBuilder.create((String)"G"));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Reference genotype data cache. Trade memory usage for speed");
        OptionBuilder.withLongOpt((String)"cache");
        OPTIONS.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Tab separated file with column 1 sample ID and column 2 sample ID in reference genotype data, no header. If only contains a mapping for a subset of samples the original identifier in the reference is used");
        OptionBuilder.withLongOpt((String)"sampleCoupling");
        OPTIONS.addOption(OptionBuilder.create((String)"sc"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional .gtf file for annotations of ASE effects. Must be grouped by chromosome");
        OptionBuilder.withLongOpt((String)"gtf");
        OPTIONS.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of total reads");
        OptionBuilder.withLongOpt((String)"maxReads");
        OPTIONS.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Activate debug mode. This will result in a more verbose log file");
        OptionBuilder.withLongOpt((String)"debug");
        OPTIONS.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Confine analysis to specified chromosome");
        OptionBuilder.withLongOpt((String)"chr");
        OPTIONS.addOption(OptionBuilder.create((String)"ch"));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"In the case of reference genotype data anayslis can be faster when chucked");
        OptionBuilder.withLongOpt((String)"chunkSize");
        OPTIONS.addOption(OptionBuilder.create((String)"cs"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Mappability track in BedGraph format.");
        OptionBuilder.withLongOpt((String)"mappabilityTrack");
        OPTIONS.addOption(OptionBuilder.create((String)"mt"));
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Minimum mappability to include ASE in results in Mb.");
        OptionBuilder.withLongOpt((String)"mappabilityMinimum");
        OPTIONS.addOption(OptionBuilder.create((String)"mm"));
    }
}

