/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import eqtlmappingpipeline.Main;
import eqtlmappingpipeline.ase.AseConfiguration;
import eqtlmappingpipeline.ase.AseException;
import eqtlmappingpipeline.ase.AseResults;
import eqtlmappingpipeline.ase.AseVariantAppendable;
import eqtlmappingpipeline.ase.MultipleTestingCorrectionMethod;
import eqtlmappingpipeline.ase.ReadCountsLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import umcg.genetica.collections.intervaltree.PerChrIntervalTree;
import umcg.genetica.io.bedgraph.BedGraphEntry;
import umcg.genetica.io.bedgraph.BedGraphFile;
import umcg.genetica.io.gtf.GffElement;
import umcg.genetica.io.gtf.GtfReader;

public class Ase {
    private static final String VERSION = Main.VERSION;
    private static final String HEADER = "  /---------------------------------------\\\n  |  Allele Specific Expression Mapper    |\n  |                                       |\n  |             Patrick Deelen            |\n  |        patrickdeelen@gmail.com        |\n  |                                       |\n  | Dasha Zhernakova, Marijke v/d Sijde,  |\n  |   Marc Jan Bonder, Harm-Jan Westra,   |\n  |      Lude Franke, Morris Swertz       |\n  |                                       |\n  |     Genomics Coordication Center      |\n  |        Department of Genetics         |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/";
    private static final Logger LOGGER = Logger.getLogger(Ase.class);
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Date currentDataTime = new Date();
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    public static final NumberFormat DEFAULT_NUMBER_FORMATTER = NumberFormat.getInstance();

    public static void main(String[] args) {
        AseConfiguration configuration;
        System.out.println(HEADER);
        System.out.println();
        System.out.println("          --- Version: " + VERSION + " ---");
        System.out.println();
        System.out.println("More information: http://www.molgenis.org/systemsgenetics/Allele-Specific-Expression");
        System.out.println();
        System.out.println("Current date and time: " + DATE_TIME_FORMAT.format(currentDataTime));
        System.out.println();
        System.out.flush();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (args.length == 0) {
            AseConfiguration.printHelp();
            System.exit(1);
        }
        try {
            configuration = new AseConfiguration(args);
        }
        catch (ParseException ex) {
            System.err.println("Invalid command line arguments: ");
            System.err.println(ex.getMessage());
            System.err.println();
            AseConfiguration.printHelp();
            System.exit(1);
            return;
        }
        if (!configuration.getOutputFolder().isDirectory() && !configuration.getOutputFolder().mkdirs()) {
            System.err.println("Failed to create output folder: " + configuration.getOutputFolder().getAbsolutePath());
            System.exit(1);
        }
        Ase.startLogging(configuration.getLogFile(), configuration.isDebugMode());
        configuration.printOptions();
        LOGGER.debug((Object)("Java version: " + System.getProperty("java.version")));
        try {
            PerChrIntervalTree<GffElement> gtfAnnotations;
            Map<String, String> refToStudySampleId;
            RandomAccessGenotypeData referenceGenotypes;
            AseResults aseResults = new AseResults();
            Set<String> detectedSampleSet = Collections.synchronizedSet(new HashSet());
            int minimumNumberSamples = configuration.getMinSamples();
            if (configuration.isRefSet()) {
                try {
                    referenceGenotypes = configuration.getRefDataType().createGenotypeData(configuration.getRefBasePaths(), configuration.getRefDataCacheSize());
                    System.out.println("Loading reference data complete");
                    LOGGER.info((Object)"Loading reference data complete");
                }
                catch (IOException ex) {
                    System.err.println("Unable to load reference genotypes file.");
                    LOGGER.fatal((Object)"Unable to load reference genotypes file.", (Throwable)ex);
                    System.exit(1);
                    return;
                }
                catch (IncompatibleMultiPartGenotypeDataException ex) {
                    System.err.println("Unable to load reference genotypes file.");
                    LOGGER.fatal((Object)"Unable to load reference genotypes file.", (Throwable)ex);
                    System.exit(1);
                    return;
                }
                catch (GenotypeDataException ex) {
                    System.err.println("Unable to load reference genotypes file.");
                    LOGGER.fatal((Object)"Unable to load reference genotypes file.", (Throwable)ex);
                    System.exit(1);
                    return;
                }
                if (configuration.isSampleToRefSampleFileSet()) {
                    try {
                        refToStudySampleId = Ase.readSampleMapping(configuration.getSampleToRefSampleFile());
                        System.out.println("Found " + refToStudySampleId.size() + " sample mappings");
                        LOGGER.info((Object)("Found " + refToStudySampleId.size() + " sample mappings"));
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println("Cannot find samples mapping file at: " + configuration.getSampleToRefSampleFile().getAbsolutePath());
                        LOGGER.fatal((Object)("Cannot find samples mapping file at: " + configuration.getSampleToRefSampleFile().getAbsolutePath()), (Throwable)ex);
                        System.exit(1);
                        return;
                    }
                    catch (Exception ex) {
                        System.err.println("Error reading sample mapping file: " + ex.getMessage());
                        LOGGER.fatal((Object)"Error reading sample mapping file", (Throwable)ex);
                        System.exit(1);
                        return;
                    }
                } else {
                    refToStudySampleId = null;
                }
            } else {
                referenceGenotypes = null;
                refToStudySampleId = null;
            }
            if (configuration.isGtfSet() && !configuration.getGtf().canRead()) {
                System.err.println("Cannot read GENCODE gft file.");
                LOGGER.fatal((Object)"Cannot read GENCODE gft file");
                System.exit(1);
            }
            List<File> inputFiles = configuration.getInputFiles();
            System.out.println("Loading sample allele counts");
            if (referenceGenotypes == null) {
                Ase.loadAseData(inputFiles, aseResults, detectedSampleSet, configuration, null, refToStudySampleId, configuration.getChrFilter(), true);
                Iterator<AseVariantAppendable> aseIterator = aseResults.iterator();
                while (aseIterator.hasNext()) {
                    if (aseIterator.next().getSampleCount() >= minimumNumberSamples) continue;
                    aseIterator.remove();
                }
            } else {
                int chunkSize = configuration.getChunkSize();
                for (String chr : referenceGenotypes.getSeqNames()) {
                    if (configuration.getChrFilter() != null && !configuration.getChrFilter().equals(chr)) continue;
                    int startChunk = 0;
                    while (referenceGenotypes.getVariantsByRange(chr, startChunk, Integer.MAX_VALUE).iterator().hasNext()) {
                        if (chunkSize == Integer.MAX_VALUE) {
                            System.out.println("Chr: " + chr);
                        } else {
                            System.out.println("Chr: " + chr + " chunk: " + DEFAULT_NUMBER_FORMATTER.format(startChunk) + "-" + DEFAULT_NUMBER_FORMATTER.format(startChunk + chunkSize));
                        }
                        Ase.loadAseData(inputFiles, aseResults, detectedSampleSet, configuration, referenceGenotypes, refToStudySampleId, chr, startChunk, startChunk + chunkSize - 1, false);
                        startChunk += chunkSize;
                    }
                    if (aseResults.chrIterator(chr) == null) continue;
                    Iterator<AseVariantAppendable> aseChrIterator = aseResults.chrIterator(chr);
                    while (aseChrIterator.hasNext()) {
                        if (aseChrIterator.next().getSampleCount() >= minimumNumberSamples) continue;
                        aseChrIterator.remove();
                    }
                }
            }
            boolean encounteredBaseQuality = aseResults.isEncounteredBaseQuality();
            LOGGER.info((Object)("Loading files complete. Detected " + DEFAULT_NUMBER_FORMATTER.format(detectedSampleSet.size()) + " samples."));
            System.out.println("Loading files complete. Detected " + DEFAULT_NUMBER_FORMATTER.format(detectedSampleSet.size()) + " samples.");
            if (configuration.isMappabilityTrackSet()) {
                PerChrIntervalTree<BedGraphEntry> mappabilities;
                int removeNoMappabilityInfo = 0;
                int removeLowMappability = 0;
                double minimumMappability = configuration.getMappabilityMinimum();
                try {
                    BedGraphFile bedGraphFile = new BedGraphFile(configuration.getMappabilityTrackFile());
                    mappabilities = bedGraphFile.createIntervalTree();
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Could not find mappability file at: " + configuration.getMappabilityTrackFile().getAbsolutePath());
                    LOGGER.fatal((Object)("Could not find mappability file at: " + configuration.getMappabilityTrackFile().getAbsolutePath()));
                    System.exit(1);
                    return;
                }
                catch (IOException ex) {
                    System.err.println("Could not read mappability file at: " + configuration.getMappabilityTrackFile().getAbsolutePath());
                    LOGGER.fatal((Object)("Could not read mappability file at: " + configuration.getMappabilityTrackFile().getAbsolutePath()));
                    System.exit(1);
                    return;
                }
                catch (Exception ex) {
                    System.err.println("Error reading mappability file " + ex.getMessage());
                    LOGGER.fatal((Object)("Error reading mappability file " + ex.getMessage()));
                    System.exit(1);
                    return;
                }
                Iterator<AseVariantAppendable> aseIterator = aseResults.iterator();
                while (aseIterator.hasNext()) {
                    AseVariantAppendable ase = aseIterator.next();
                    List<BedGraphEntry> aseMappabilities = mappabilities.searchPosition(ase.getChr(), ase.getPos());
                    if (aseMappabilities.isEmpty()) {
                        aseIterator.remove();
                        ++removeNoMappabilityInfo;
                        continue;
                    }
                    if (aseMappabilities.size() > 1) {
                        System.err.println("Error reading mappability file " + ase.getChr() + ":" + ase.getPos() + " contains multiple mappability scores");
                        LOGGER.fatal((Object)("Error reading mappability file " + ase.getChr() + ":" + ase.getPos() + " contains multiple mappability scores"));
                        System.exit(1);
                        return;
                    }
                    if (!(aseMappabilities.get(0).getValue() < minimumMappability)) continue;
                    ++removeLowMappability;
                    aseIterator.remove();
                }
                System.out.println("ASE removed due to low mappability: " + DEFAULT_NUMBER_FORMATTER.format(removeLowMappability));
                LOGGER.info((Object)("ASE removed due to low mappability: " + DEFAULT_NUMBER_FORMATTER.format(removeLowMappability)));
                if (removeNoMappabilityInfo != 0) {
                    System.out.println("ASE removed due to no mappability info present: " + DEFAULT_NUMBER_FORMATTER.format(removeNoMappabilityInfo));
                    LOGGER.info((Object)("ASE removed due to no mappability info present: " + DEFAULT_NUMBER_FORMATTER.format(removeNoMappabilityInfo)));
                }
            }
            Object[] aseVariants = new AseVariantAppendable[aseResults.getCount()];
            int i = 0;
            for (AseVariantAppendable aseVariant : aseResults) {
                aseVariant.calculateStatistics();
                aseVariants[i] = aseVariant;
                ++i;
            }
            Arrays.sort(aseVariants);
            if (configuration.isGtfSet()) {
                try {
                    System.out.println("Started loading GTF file.");
                    gtfAnnotations = new GtfReader(configuration.getGtf()).createIntervalTree();
                    System.out.println("Loaded " + DEFAULT_NUMBER_FORMATTER.format(gtfAnnotations.size()) + " annotations from GTF file.");
                    LOGGER.info((Object)("Loaded " + DEFAULT_NUMBER_FORMATTER.format(gtfAnnotations.size()) + " annotations from GTF file."));
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Cannot read GENCODE gft file.");
                    LOGGER.fatal((Object)"Cannot read GENCODE gft file", (Throwable)ex);
                    System.exit(1);
                    return;
                }
                catch (Exception ex) {
                    System.err.println("Cannot read GENCODE gft file. Error: " + ex.getMessage());
                    LOGGER.fatal((Object)"Cannot read GENCODE gft file", (Throwable)ex);
                    System.exit(1);
                    return;
                }
            } else {
                gtfAnnotations = null;
            }
            for (MultipleTestingCorrectionMethod correctionMethod : EnumSet.of(MultipleTestingCorrectionMethod.NONE, MultipleTestingCorrectionMethod.BONFERRONI, MultipleTestingCorrectionMethod.HOLM, MultipleTestingCorrectionMethod.BH)) {
                File outputFileBonferroni = new File(configuration.getOutputFolder(), correctionMethod == MultipleTestingCorrectionMethod.NONE ? "ase.txt" : "ase_" + correctionMethod.toString().toLowerCase() + ".txt");
                try {
                    int writtenResults = Ase.printAseResults(outputFileBonferroni, (AseVariantAppendable[])aseVariants, gtfAnnotations, correctionMethod, encounteredBaseQuality);
                    if (correctionMethod == MultipleTestingCorrectionMethod.NONE) {
                        System.out.println("Completed writing all " + DEFAULT_NUMBER_FORMATTER.format(writtenResults) + " ASE variants");
                        LOGGER.info((Object)("Completed writing all " + DEFAULT_NUMBER_FORMATTER.format(writtenResults) + " ASE variants"));
                        continue;
                    }
                    System.out.println("Completed writing " + DEFAULT_NUMBER_FORMATTER.format(writtenResults) + " " + correctionMethod.toString().toLowerCase() + " significant ASE variants");
                    LOGGER.info((Object)("Completed writing " + DEFAULT_NUMBER_FORMATTER.format(writtenResults) + " " + correctionMethod.toString().toLowerCase() + " significant ASE variants"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Unable to create output file at " + outputFileBonferroni.getAbsolutePath());
                    LOGGER.fatal((Object)("Unable to create output file at " + outputFileBonferroni.getAbsolutePath()), (Throwable)ex);
                    System.exit(1);
                    return;
                }
                catch (IOException ex) {
                    System.err.println("Unable to create output file at " + outputFileBonferroni.getAbsolutePath());
                    LOGGER.fatal((Object)("Unable to create output file at " + outputFileBonferroni.getAbsolutePath()), (Throwable)ex);
                    System.exit(1);
                    return;
                }
                catch (AseException ex) {
                    System.err.println("Error creating output file: " + ex.getMessage());
                    LOGGER.fatal((Object)"Error creating output file.", (Throwable)ex);
                    System.exit(1);
                    return;
                }
            }
            System.out.println("Program completed");
            LOGGER.info((Object)"Program completed");
        }
        catch (OutOfMemoryError ex) {
            System.err.println("Error: out of memory, use -Xmx##g -Xms##g to reserve more memory, see manual for more information.");
            LOGGER.fatal((Object)"Out of memory, use -Xmx##g -Xms##g to reserve more memory, see manual for more information.", (Throwable)ex);
            System.exit(1);
        }
    }

    private static void startLogging(File logFile, boolean debugMode) {
        try {
            FileAppender logAppender = new FileAppender((Layout)new SimpleLayout(), logFile.getCanonicalPath(), false);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)logAppender);
            if (debugMode) {
                LOGGER.setLevel(Level.DEBUG);
            } else {
                LOGGER.setLevel(Level.INFO);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create logger: " + e.getMessage());
            System.exit(1);
        }
        LOGGER.info((Object)"\n  /---------------------------------------\\\n  |  Allele Specific Expression Mapper    |\n  |                                       |\n  |             Patrick Deelen            |\n  |        patrickdeelen@gmail.com        |\n  |                                       |\n  | Dasha Zhernakova, Marijke v/d Sijde,  |\n  |   Marc Jan Bonder, Harm-Jan Westra,   |\n  |      Lude Franke, Morris Swertz       |\n  |                                       |\n  |     Genomics Coordication Center      |\n  |        Department of Genetics         |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/");
        LOGGER.info((Object)("Version: " + VERSION));
        LOGGER.info((Object)("Current date and time: " + DATE_TIME_FORMAT.format(currentDataTime)));
        LOGGER.info((Object)("Log level: " + LOGGER.getLevel()));
        System.out.println("Started logging");
        System.out.println();
    }

    private static int printAseResults(File outputFile, AseVariantAppendable[] aseVariants, PerChrIntervalTree<GffElement> gtfAnnotations, boolean encounteredBaseQuality) throws UnsupportedEncodingException, FileNotFoundException, IOException, AseException {
        return Ase.printAseResults(outputFile, aseVariants, gtfAnnotations, MultipleTestingCorrectionMethod.NONE, encounteredBaseQuality);
    }

    private static int printAseResults(File outputFile, AseVariantAppendable[] aseVariants, PerChrIntervalTree<GffElement> gtfAnnotations, MultipleTestingCorrectionMethod multipleTestingCorrectionMethod, boolean encounteredBaseQuality) throws UnsupportedEncodingException, FileNotFoundException, IOException, AseException {
        BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        outputWriter.append("LikelihoodRatioP\tLikelihoodRatioD\teffect\tMeta_P\tMeta_Z\tChr\tPos\tSnpId\tSample_Count\tRef_Allele\tAlt_Allele\tCount_Pearson_R\tGenes\tRef_Counts\tAlt_Counts\tBinom_P\tSampleIds");
        outputWriter.append('\n');
        double significance = 0.05;
        int counter = 0;
        double lastRatioD = Double.POSITIVE_INFINITY;
        int totalNumberOfTests = aseVariants.length;
        double bonferroniCutoff = 0.05 / (double)totalNumberOfTests;
        HashSet<String> genesPrinted = new HashSet<String>();
        block7: for (AseVariantAppendable aseVariant : aseVariants) {
            int i;
            double ratioD = aseVariant.getMle().getRatioD();
            if (ratioD > lastRatioD) {
                throw new AseException("ASE results not sorted");
            }
            lastRatioD = ratioD;
            switch (multipleTestingCorrectionMethod) {
                case NONE: {
                    break;
                }
                case NOMINAL: {
                    if (!(aseVariant.getMle().getRatioP() > 0.05)) break;
                    break block7;
                }
                case BONFERRONI: {
                    if (!(aseVariant.getMle().getRatioP() > bonferroniCutoff)) break;
                    break block7;
                }
                case HOLM: {
                    double holmCutoff = 0.05 / (double)(totalNumberOfTests - counter);
                    if (!(aseVariant.getMle().getRatioP() > holmCutoff)) break;
                    break block7;
                }
                case BH: {
                    double qvalue = ((double)counter + 1.0) / (double)totalNumberOfTests * 0.05;
                    if (!(aseVariant.getMle().getRatioP() > qvalue)) break;
                    break block7;
                }
                default: {
                    throw new AseException("Multiple testing method: " + (Object)((Object)multipleTestingCorrectionMethod) + " is not supported");
                }
            }
            ++counter;
            outputWriter.append(String.valueOf(aseVariant.getMle().getRatioP()));
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getMle().getRatioD()));
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getMle().getMaxLikelihoodP()));
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getMetaPvalue()));
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getMetaZscore()));
            outputWriter.append('\t');
            outputWriter.append(aseVariant.getChr());
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getPos()));
            outputWriter.append('\t');
            outputWriter.append(aseVariant.getId().getPrimairyId() == null ? "." : aseVariant.getId().getPrimairyId());
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getSampleCount()));
            outputWriter.append('\t');
            outputWriter.append(aseVariant.getA1().getAlleleAsString());
            outputWriter.append('\t');
            outputWriter.append(aseVariant.getA2().getAlleleAsString());
            outputWriter.append('\t');
            outputWriter.append(String.valueOf(aseVariant.getCountPearsonR()));
            outputWriter.append('\t');
            if (gtfAnnotations != null) {
                genesPrinted.clear();
                List<GffElement> elements = gtfAnnotations.searchPosition(aseVariant.getChr(), aseVariant.getPos());
                boolean first = true;
                for (GffElement element : elements) {
                    String geneId = element.getAttributeValue("gene_id");
                    if (genesPrinted.contains(geneId)) continue;
                    if (first) {
                        first = false;
                    } else {
                        outputWriter.append(',');
                    }
                    outputWriter.append(geneId);
                    genesPrinted.add(geneId);
                }
            }
            outputWriter.append('\t');
            for (i = 0; i < aseVariant.getA1Counts().size(); ++i) {
                if (i > 0) {
                    outputWriter.append(',');
                }
                outputWriter.append(String.valueOf(aseVariant.getA1Counts().getQuick(i)));
            }
            outputWriter.append('\t');
            for (i = 0; i < aseVariant.getA2Counts().size(); ++i) {
                if (i > 0) {
                    outputWriter.append(',');
                }
                outputWriter.append(String.valueOf(aseVariant.getA2Counts().getQuick(i)));
            }
            outputWriter.append('\t');
            for (i = 0; i < aseVariant.getPValues().size(); ++i) {
                if (i > 0) {
                    outputWriter.append(',');
                }
                outputWriter.append(String.valueOf(aseVariant.getPValues().getQuick(i)));
            }
            outputWriter.append('\t');
            for (i = 0; i < aseVariant.getSampleIds().size(); ++i) {
                if (i > 0) {
                    outputWriter.append(',');
                }
                outputWriter.append(aseVariant.getSampleIds().get(i));
            }
            outputWriter.append('\n');
        }
        outputWriter.close();
        return counter;
    }

    private static Map<String, String> readSampleMapping(File sampleToRefSampleFile) throws FileNotFoundException, UnsupportedEncodingException, IOException, Exception {
        String line;
        HashMap<String, String> sampleMap = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sampleToRefSampleFile), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            String[] elements = TAB_PATTERN.split(line);
            if (elements.length != 2) {
                throw new Exception("Detected " + elements.length + " columns instead of 2 for this line: " + line);
            }
            sampleMap.put(elements[1], elements[0]);
        }
        return Collections.unmodifiableMap(sampleMap);
    }

    private static void loadAseData(List<File> inputFiles, AseResults aseResults, Set<String> detectedSampleSet, AseConfiguration configuration, RandomAccessGenotypeData referenceGenotypes, Map<String, String> refToStudySampleId, String chr, boolean showFileProgress) {
        Ase.loadAseData(inputFiles, aseResults, detectedSampleSet, configuration, referenceGenotypes, refToStudySampleId, chr, 0, Integer.MAX_VALUE, showFileProgress);
    }

    private static void loadAseData(List<File> inputFiles, AseResults aseResults, Set<String> detectedSampleSet, AseConfiguration configuration, RandomAccessGenotypeData referenceGenotypes, Map<String, String> refToStudySampleId, String chr, int start, int stop, boolean showFileProgress) {
        boolean running;
        AtomicInteger fileCounter = new AtomicInteger(0);
        int threadCount = configuration.getInputFiles().size() < configuration.getThreads() ? configuration.getInputFiles().size() : configuration.getThreads();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        ThreadErrorHandler threadErrorHandler = new ThreadErrorHandler();
        Iterator<File> inputFileIterator = inputFiles.iterator();
        for (int i = 0; i < threadCount; ++i) {
            Thread worker = new Thread(new ReadCountsLoader(inputFileIterator, aseResults, detectedSampleSet, fileCounter, configuration, referenceGenotypes, refToStudySampleId, chr, start, stop));
            worker.setUncaughtExceptionHandler(threadErrorHandler);
            worker.start();
            threads.add(worker);
        }
        int nextReport = 100;
        do {
            int currentCount;
            running = false;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                running = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!showFileProgress || (currentCount = fileCounter.get()) <= nextReport) continue;
            System.out.println("Loaded " + DEFAULT_NUMBER_FORMATTER.format(nextReport) + " out of " + DEFAULT_NUMBER_FORMATTER.format(configuration.getInputFiles().size()) + " files");
            nextReport += 100;
        } while (running);
    }

    private static class ThreadErrorHandler
    implements Thread.UncaughtExceptionHandler {
        private ThreadErrorHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof OutOfMemoryError) {
                System.err.println("Error: out of memory, use -Xmx##g -Xms##g to reserve more memory, see manual for more information.");
                LOGGER.fatal((Object)"Out of memory, use -Xmx##g -Xms##g to reserve more memory, see manual for more information.", e);
            } else {
                System.err.println("Fatal error: " + e.getMessage());
                LOGGER.fatal((Object)"Fatal error: ", e);
            }
            System.exit(1);
        }
    }
}

