/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.simevents.Continuous;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;

public class PreyPred {
    double r = 0.005;
    double c = 1.0E-5;
    double s = 0.01;
    double d = 5.0E-6;
    double h = 5.0;
    double x0 = 2000.0;
    double z0 = 150.0;
    double horizon = 501.0;
    Simulator sim = new Simulator();
    Continuous x = new Preys(this.sim);
    Continuous z = new Preds(this.sim);

    public static void main(String[] args) {
        new PreyPred();
    }

    public PreyPred() {
        this.sim.init();
        new EndOfSim(this.sim).schedule(this.horizon);
        new PrintPoint(this.sim).schedule(this.h);
        this.sim.continuousState().selectRungeKutta4(this.h);
        this.x.startInteg(this.x0);
        this.z.startInteg(this.z0);
        this.sim.start();
    }

    class EndOfSim
    extends Event {
        public EndOfSim(Simulator sim) {
            super(sim);
        }

        public void actions() {
            this.sim.stop();
        }
    }

    class PrintPoint
    extends Event {
        public PrintPoint(Simulator sim) {
            super(sim);
        }

        public void actions() {
            System.out.println(this.sim.time() + "  " + PreyPred.this.x.value() + "  " + PreyPred.this.z.value());
            this.schedule(PreyPred.this.h);
        }
    }

    public class Preds
    extends Continuous {
        public Preds(Simulator sim) {
            super(sim);
        }

        public double derivative(double t) {
            return -PreyPred.this.s * this.value() + PreyPred.this.d * PreyPred.this.x.value() * this.value();
        }
    }

    public class Preys
    extends Continuous {
        public Preys(Simulator sim) {
            super(sim);
        }

        public double derivative(double t) {
            return PreyPred.this.r * this.value() - PreyPred.this.c * this.value() * PreyPred.this.z.value();
        }
    }
}

