/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Scanner;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.Tally;

public class CallEv {
    static final double HOUR = 3600.0;
    int numDays;
    double openingTime;
    int numPeriods;
    int[] numAgents;
    double[] lambda;
    double alpha0;
    double p;
    double nu;
    double alpha;
    double beta;
    double s;
    double busyness;
    double arrRate = 0.0;
    int nAgents;
    int nBusy;
    int nArrivals;
    int nAbandon;
    int nGoodQoS;
    double nCallsExpected;
    Event nextArrival = new Arrival();
    RandomStream streamW = new MRG32k3a();
    RandomStream streamArr = new MRG32k3a();
    RandomStream streamPatience = new MRG32k3a();
    GammaGen genServ;
    LinkedListStat<Call> waitList = new LinkedListStat("Waiting calls");
    Tally statArrivals = new Tally("Number of arrivals per day");
    Tally statWaits = new Tally("Average waiting time per customer");
    Tally statWaitsDay = new Tally("Waiting times within a day");
    Tally statGoodQoS = new Tally("Proportion of waiting times < s");
    Tally statAbandon = new Tally("Proportion of calls lost");

    public static void main(String[] args) throws IOException {
        new CallEv();
    }

    public CallEv() throws IOException {
        this.readData();
        for (int i = 1; i <= this.numDays; ++i) {
            this.simulOneDay();
        }
        System.out.println("\n Num. calls expected = " + this.nCallsExpected + "\n");
        this.statArrivals.setConfidenceIntervalStudent();
        this.statWaits.setConfidenceIntervalStudent();
        this.statGoodQoS.setConfidenceIntervalStudent();
        this.statAbandon.setConfidenceIntervalStudent();
        System.out.println(this.statArrivals.report(0.9, 3));
        System.out.println(this.statWaits.report(0.9, 3));
        System.out.println(this.statGoodQoS.report(0.9, 3));
        System.out.println(this.statAbandon.report(0.9, 3));
    }

    public void checkQueue() {
        while (this.waitList.size() > 0 && this.nBusy < this.nAgents) {
            Call call = this.waitList.removeFirst();
            double wait = Sim.time() - call.arrivTime;
            if (call.patienceTime < wait) {
                ++this.nAbandon;
                wait = call.patienceTime;
            } else {
                ++this.nBusy;
                new CallCompletion().schedule(call.servTime);
            }
            if (wait < this.s) {
                ++this.nGoodQoS;
            }
            this.statWaitsDay.add(wait);
        }
    }

    public double generPatience() {
        double u = this.streamPatience.nextDouble();
        if (u <= this.p) {
            return 0.0;
        }
        return ExponentialDist.inverseF(this.nu, (1.0 - u) / (1.0 - this.p));
    }

    public void readData() throws IOException {
        Locale loc = Locale.getDefault();
        Locale.setDefault(Locale.US);
        BufferedReader input = new BufferedReader(new FileReader("CallEv.dat"));
        Scanner scan = new Scanner(input);
        this.numDays = scan.nextInt();
        scan.nextLine();
        this.openingTime = scan.nextDouble();
        scan.nextLine();
        this.numPeriods = scan.nextInt();
        scan.nextLine();
        this.numAgents = new int[this.numPeriods];
        this.lambda = new double[this.numPeriods];
        this.nCallsExpected = 0.0;
        for (int j = 0; j < this.numPeriods; ++j) {
            this.numAgents[j] = scan.nextInt();
            this.lambda[j] = scan.nextDouble();
            this.nCallsExpected += this.lambda[j];
            scan.nextLine();
        }
        this.alpha0 = scan.nextDouble();
        scan.nextLine();
        this.p = scan.nextDouble();
        scan.nextLine();
        this.nu = scan.nextDouble();
        scan.nextLine();
        this.alpha = scan.nextDouble();
        scan.nextLine();
        this.beta = scan.nextDouble();
        scan.nextLine();
        this.s = scan.nextDouble();
        scan.close();
        Locale.setDefault(loc);
        this.genServ = new GammaAcceptanceRejectionGen((RandomStream)new MRG32k3a(), this.alpha, this.beta);
    }

    public void simulOneDay() {
        Sim.init();
        this.statWaitsDay.init();
        this.nArrivals = 0;
        this.nAbandon = 0;
        this.nGoodQoS = 0;
        this.nBusy = 0;
        this.busyness = GammaDist.inverseF(this.alpha0, this.alpha0, 8, this.streamW.nextDouble());
        new NextPeriod(0).schedule(this.openingTime * 3600.0);
        Sim.start();
        this.statArrivals.add(this.nArrivals);
        this.statAbandon.add((double)this.nAbandon / this.nCallsExpected);
        this.statGoodQoS.add((double)this.nGoodQoS / this.nCallsExpected);
        this.statWaits.add(this.statWaitsDay.sum() / this.nCallsExpected);
    }

    class CallCompletion
    extends Event {
        CallCompletion() {
        }

        public void actions() {
            --CallEv.this.nBusy;
            CallEv.this.checkQueue();
        }
    }

    class Arrival
    extends Event {
        Arrival() {
        }

        public void actions() {
            CallEv.this.nextArrival.schedule(ExponentialDist.inverseF(CallEv.this.arrRate, CallEv.this.streamArr.nextDouble()));
            ++CallEv.this.nArrivals;
            Call call = new Call();
            call.servTime = CallEv.this.genServ.nextDouble();
            if (CallEv.this.nBusy < CallEv.this.nAgents) {
                ++CallEv.this.nBusy;
                ++CallEv.this.nGoodQoS;
                CallEv.this.statWaitsDay.add(0.0);
                new CallCompletion().schedule(call.servTime);
            } else {
                call.patienceTime = CallEv.this.generPatience();
                call.arrivTime = Sim.time();
                CallEv.this.waitList.addLast(call);
            }
        }
    }

    class NextPeriod
    extends Event {
        int j;

        public NextPeriod(int period) {
            this.j = period;
        }

        public void actions() {
            if (this.j < CallEv.this.numPeriods) {
                CallEv.this.nAgents = CallEv.this.numAgents[this.j];
                CallEv.this.arrRate = CallEv.this.busyness * CallEv.this.lambda[this.j] / 3600.0;
                if (this.j == 0) {
                    CallEv.this.nextArrival.schedule(ExponentialDist.inverseF(CallEv.this.arrRate, CallEv.this.streamArr.nextDouble()));
                } else {
                    CallEv.this.checkQueue();
                    CallEv.this.nextArrival.reschedule((CallEv.this.nextArrival.time() - Sim.time()) * CallEv.this.lambda[this.j - 1] / CallEv.this.lambda[this.j]);
                }
                new NextPeriod(this.j + 1).schedule(3600.0);
            } else {
                CallEv.this.nextArrival.cancel();
            }
        }
    }

    class Call {
        double arrivTime;
        double servTime;
        double patienceTime;

        Call() {
        }
    }
}

