/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.EngineerMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.Signal;

public final class FWTCoef
implements NumericalConstants,
Cloneable {
    protected double[][] coefs;
    static final double normalisation = 0.7071067811865475;

    public FWTCoef() {
    }

    public FWTCoef(double[][] dArray) {
        this.coefs = dArray;
    }

    public Object clone() {
        try {
            FWTCoef fWTCoef = (FWTCoef)super.clone();
            if (this.coefs != null) {
                fWTCoef.coefs = ArrayMath.copy(this.coefs);
            }
            return fWTCoef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getJ() {
        return this.coefs.length;
    }

    public int dimension(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("This dimension doesn't exist : " + n + ", " + this.coefs.length);
        }
        return this.coefs[n].length;
    }

    public double[][] getCoefs() {
        return this.coefs;
    }

    public double[] norm() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.norm(this.coefs[i]);
        }
        return dArray;
    }

    public double norm(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.norm(this.coefs[n]);
        return d;
    }

    private double[] sumSquares() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.sumSquares(this.coefs[i]);
        }
        return dArray;
    }

    public double sumSquares(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.sumSquares(this.coefs[n]);
        return d;
    }

    public double mass(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.mass(this.coefs[n]);
        return d;
    }

    private double[] variance() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.variance(this.coefs[i]);
        }
        return dArray;
    }

    public double variance(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.variance(this.coefs[n]);
        return d;
    }

    public double sumEnergies() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.sumSquares();
        double d = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public double entropy() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = this.sumEnergies();
        int n = 0;
        for (int i = 1; i < this.coefs.length; ++i) {
            n += this.coefs[i].length;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 1; i < this.coefs.length; ++i) {
            for (int j = 0; j < this.coefs[i].length; ++j) {
                dArray[n2] = this.coefs[i][j] * this.coefs[i][j] / d;
                ++n2;
            }
        }
        return EngineerMath.icf(dArray);
    }

    public double sumVariance() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.variance();
        double d = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public double energyRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumEnergies() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.sumSquares(n) / this.sumEnergies();
    }

    public double varianceRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumVariance() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.variance(n) / this.sumVariance();
    }

    public double icf() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        for (int i = 1; i < this.coefs.length; ++i) {
            dArray[i - 1] = this.energyRatio(i);
        }
        return EngineerMath.icf(dArray);
    }

    public double varianceICF() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        for (int i = 1; i < this.coefs.length; ++i) {
            dArray[i - 1] = this.varianceRatio(i);
        }
        return EngineerMath.icf(dArray);
    }

    public void setCoefs(double[][] dArray) {
        this.coefs = dArray;
    }

    public void setCoefs(double[] dArray, int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        this.coefs[n] = dArray;
    }

    public void synthesize(Filter filter, double[] dArray) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis possible : " + this.coefs.length);
        }
        double[] dArray2 = filter.lowpass(this.coefs[0], dArray);
        double[] dArray3 = filter.highpass(this.coefs[this.coefs.length - 1], dArray);
        if ((dArray2 = ArrayMath.scalarMultiply(0.7071067811865475, dArray2)).length != dArray3.length) {
            throw new IllegalArgumentException("Synthesis impossible : bad data/multiresolution?" + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray2.length + ", " + dArray3.length);
        }
        dArray2 = ArrayMath.add(dArray2, dArray3);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        for (int i = 1; i < this.coefs.length - 1; ++i) {
            dArrayArray[i] = this.coefs[i];
        }
        dArrayArray[0] = dArray2;
        this.coefs = dArrayArray;
    }

    public void synthesize(Filter filter, double[] dArray, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int i = 0; i < n; ++i) {
            this.synthesize(filter, dArray);
        }
    }

    public void synthesizeAll(Filter filter, double[] dArray) {
        this.synthesize(filter, dArray, this.coefs.length - 1);
    }

    public void synthesize(Filter filter) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis possible : " + this.coefs.length);
        }
        double[] dArray = filter.lowpass(this.coefs[0]);
        double[] dArray2 = filter.highpass(this.coefs[this.coefs.length - 1]);
        if ((dArray = ArrayMath.scalarMultiply(0.7071067811865475, dArray)).length != dArray2.length) {
            throw new IllegalArgumentException("Synthesis impossible : bad data/multiresolution?" + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray.length + ", " + dArray2.length);
        }
        dArray = ArrayMath.add(dArray, dArray2);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        for (int i = 1; i < this.coefs.length - 1; ++i) {
            dArrayArray[i] = this.coefs[i];
        }
        dArrayArray[0] = dArray;
        this.coefs = dArrayArray;
    }

    public void synthesize(Filter filter, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int i = 0; i < n; ++i) {
            this.synthesize(filter);
        }
    }

    public void synthesizeAll(Filter filter) {
        this.synthesize(filter, this.coefs.length - 1);
    }

    public Signal rebuildSignal(Filter filter) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public Signal rebuildSignal(Filter filter, double[] dArray) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter, dArray);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public void denoise(double d) {
        for (int i = 1; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTCoef.denoise(this.coefs[i], d);
        }
    }

    public void denoise(double d, int n) {
        this.coefs[n] = FWTCoef.denoise(this.coefs[n], d);
    }

    public static double[] denoise(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile(ArrayMath.abs(dArray2), 1.0 - d);
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) >= d2)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void compress(double d) {
        for (int i = 1; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTCoef.compress(this.coefs[i], d);
        }
    }

    public void compress(double d, int n) {
        this.coefs[n] = FWTCoef.compress(this.coefs[n], d);
    }

    public static double[] compress(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile(ArrayMath.abs(dArray2), d);
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) <= d2)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void denoiseHard(double d) {
        for (int i = 1; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTCoef.denoiseHard(this.coefs[i], d);
        }
    }

    public void denoiseHard(double d, int n) {
        this.coefs[n] = FWTCoef.denoiseHard(this.coefs[n], d);
    }

    public static double[] denoiseHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) >= d)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void compressHard(double d) {
        for (int i = 1; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTCoef.compressHard(this.coefs[i], d);
        }
    }

    public void compressHard(double d, int n) {
        this.coefs[n] = FWTCoef.compressHard(this.coefs[n], d);
    }

    public static double[] compressHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) <= d)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }
}

