/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.RealFunction;
import JSci.maths.analysis.RealFunction3D;
import JSci.maths.analysis.RealFunctionND;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class RealFunction2D
implements Ring.Member {
    public abstract double map(double var1, double var3);

    public final int dimension() {
        return 2;
    }

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RealFunction2D) {
            return this.add((RealFunction2D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D add(RealFunction2D realFunction2D) {
        return new Sum(this, realFunction2D);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RealFunction2D) {
            return this.subtract((RealFunction2D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D subtract(RealFunction2D realFunction2D) {
        return new Difference(this, realFunction2D);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof RealFunction2D) {
            return this.multiply((RealFunction2D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D multiply(RealFunction2D realFunction2D) {
        return new Product(this, realFunction2D);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member member) {
        if (member instanceof RealFunction2D) {
            return this.divide((RealFunction2D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D divide(RealFunction2D realFunction2D) {
        return new Quotient(this, realFunction2D);
    }

    public RealFunction3D tensor(RealFunction realFunction) {
        return new TensorProduct3D(this, realFunction);
    }

    public RealFunctionND tensor(RealFunction2D realFunction2D) {
        return new TensorProduct4D(this, realFunction2D);
    }

    public static RealFunction2D constant(double d) {
        return new Constant(d);
    }

    private static class Constant
    extends RealFunction2D {
        private final double A;

        public Constant(double d) {
            this.A = d;
        }

        public double map(double d, double d2) {
            return this.A;
        }
    }

    private static class TensorProduct4D
    extends RealFunctionND {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public TensorProduct4D(RealFunction2D realFunction2D, RealFunction2D realFunction2D2) {
            super(4);
            this.f1 = realFunction2D;
            this.f2 = realFunction2D2;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray[0], dArray[1]) * this.f2.map(dArray[2], dArray[3]);
        }
    }

    private static class TensorProduct3D
    extends RealFunction3D {
        private final RealFunction2D f1;
        private final RealFunction f2;

        public TensorProduct3D(RealFunction2D realFunction2D, RealFunction realFunction) {
            this.f1 = realFunction2D;
            this.f2 = realFunction;
        }

        public double map(double d, double d2, double d3) {
            return this.f1.map(d, d2) * this.f2.map(d3);
        }
    }

    private static class Quotient
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Quotient(RealFunction2D realFunction2D, RealFunction2D realFunction2D2) {
            this.f1 = realFunction2D;
            this.f2 = realFunction2D2;
        }

        public double map(double d, double d2) {
            return this.f1.map(d, d2) / this.f2.map(d, d2);
        }
    }

    private static class Reciprocal
    extends RealFunction2D {
        private final RealFunction2D f;

        public Reciprocal(RealFunction2D realFunction2D) {
            this.f = realFunction2D;
        }

        public double map(double d, double d2) {
            return 1.0 / this.f.map(d, d2);
        }
    }

    private static class Product
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Product(RealFunction2D realFunction2D, RealFunction2D realFunction2D2) {
            this.f1 = realFunction2D;
            this.f2 = realFunction2D2;
        }

        public double map(double d, double d2) {
            return this.f1.map(d, d2) * this.f2.map(d, d2);
        }
    }

    private static class Difference
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Difference(RealFunction2D realFunction2D, RealFunction2D realFunction2D2) {
            this.f1 = realFunction2D;
            this.f2 = realFunction2D2;
        }

        public double map(double d, double d2) {
            return this.f1.map(d, d2) - this.f2.map(d, d2);
        }
    }

    private static class Sum
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Sum(RealFunction2D realFunction2D, RealFunction2D realFunction2D2) {
            this.f1 = realFunction2D;
            this.f2 = realFunction2D2;
        }

        public double map(double d, double d2) {
            return this.f1.map(d, d2) + this.f2.map(d, d2);
        }
    }

    private static class Negation
    extends RealFunction2D {
        private final RealFunction2D f;

        public Negation(RealFunction2D realFunction2D) {
            this.f = realFunction2D;
        }

        public double map(double d, double d2) {
            return -this.f.map(d, d2);
        }
    }
}

