/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import java.util.Objects;
import org.molgenis.data.settings.SettingsPopulator;
import org.molgenis.framework.db.WebAppDatabasePopulator;
import org.molgenis.script.ScriptTypePopulator;
import org.molgenis.ui.I18nStringsPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class RepositoryPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryPopulator.class);
    private final WebAppDatabasePopulator webAppDatabasePopulator;
    private final SettingsPopulator settingsPopulator;
    private final I18nStringsPopulator i18nStringsPopulator;
    private final ScriptTypePopulator scriptTypePopulator;

    @Autowired
    public RepositoryPopulator(WebAppDatabasePopulator webAppDatabasePopulator, SettingsPopulator settingsPopulator, I18nStringsPopulator i18nStringsPopulator, ScriptTypePopulator scriptTypePopulator) {
        this.webAppDatabasePopulator = Objects.requireNonNull(webAppDatabasePopulator);
        this.settingsPopulator = Objects.requireNonNull(settingsPopulator);
        this.i18nStringsPopulator = Objects.requireNonNull(i18nStringsPopulator);
        this.scriptTypePopulator = Objects.requireNonNull(scriptTypePopulator);
    }

    public void populate(ContextRefreshedEvent event) {
        LOG.trace("Populating database ...");
        this.webAppDatabasePopulator.populateDatabase();
        LOG.trace("Populated database");
        LOG.trace("Populating settings entities ...");
        this.settingsPopulator.initialize(event);
        LOG.trace("Populated settings entities");
        LOG.trace("Populating database with I18N strings ...");
        this.i18nStringsPopulator.populate();
        LOG.trace("Populated database with I18N strings");
        LOG.trace("Populating script type entities ...");
        this.scriptTypePopulator.populate();
        LOG.trace("Populated script type entities");
    }
}

