/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import java.util.Objects;
import org.molgenis.bootstrap.MolgenisUpgradeBootstrapper;
import org.molgenis.bootstrap.RegistryBootstrapper;
import org.molgenis.bootstrap.RepositoryPopulator;
import org.molgenis.data.annotation.web.bootstrap.AnnotatorBootstrapper;
import org.molgenis.data.elasticsearch.bootstrap.IndexBootstrapper;
import org.molgenis.data.idcard.IdCardBootstrapper;
import org.molgenis.data.jobs.JobBootstrapper;
import org.molgenis.data.platform.bootstrap.SystemEntityMetaDataBootstrapper;
import org.molgenis.file.ingest.FileIngesterJobRegistrar;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class MolgenisBootstrapper
implements ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(MolgenisBootstrapper.class);
    private final MolgenisUpgradeBootstrapper upgradeBootstrapper;
    private final RegistryBootstrapper registryBootstrapper;
    private final SystemEntityMetaDataBootstrapper systemEntityMetaDataBootstrapper;
    private final RepositoryPopulator repositoryPopulator;
    private final FileIngesterJobRegistrar fileIngesterJobRegistrar;
    private final JobBootstrapper jobBootstrapper;
    private final IdCardBootstrapper idCardBootstrapper;
    private final AnnotatorBootstrapper annotatorBootstrapper;
    private final IndexBootstrapper indexBootstrapper;

    @Autowired
    public MolgenisBootstrapper(MolgenisUpgradeBootstrapper upgradeBootstrapper, RegistryBootstrapper registryBootstrapper, SystemEntityMetaDataBootstrapper systemEntityMetaDataBootstrapper, RepositoryPopulator repositoryPopulator, FileIngesterJobRegistrar fileIngesterJobRegistrar, JobBootstrapper jobBootstrapper, IdCardBootstrapper idCardBootstrapper, AnnotatorBootstrapper annotatorBootstrapper, IndexBootstrapper indexBootstrapper) {
        this.upgradeBootstrapper = Objects.requireNonNull(upgradeBootstrapper);
        this.registryBootstrapper = Objects.requireNonNull(registryBootstrapper);
        this.systemEntityMetaDataBootstrapper = Objects.requireNonNull(systemEntityMetaDataBootstrapper);
        this.repositoryPopulator = Objects.requireNonNull(repositoryPopulator);
        this.fileIngesterJobRegistrar = Objects.requireNonNull(fileIngesterJobRegistrar);
        this.jobBootstrapper = Objects.requireNonNull(jobBootstrapper);
        this.idCardBootstrapper = Objects.requireNonNull(idCardBootstrapper);
        this.annotatorBootstrapper = Objects.requireNonNull(annotatorBootstrapper);
        this.indexBootstrapper = Objects.requireNonNull(indexBootstrapper);
    }

    @Transactional
    @RunAsSystem
    public void onApplicationEvent(ContextRefreshedEvent event) {
        LOG.info("Bootstrapping application ...");
        LOG.trace("Updating MOLGENIS ...");
        this.upgradeBootstrapper.bootstrap();
        LOG.debug("Updated MOLGENIS");
        LOG.trace("Bootstrapping registries ...");
        this.registryBootstrapper.bootstrap(event);
        LOG.debug("Bootstrapped registries");
        LOG.trace("Bootstrapping system entity meta data ...");
        this.systemEntityMetaDataBootstrapper.bootstrap(event);
        LOG.debug("Bootstrapped system entity meta data");
        LOG.trace("Populating repositories ...");
        this.repositoryPopulator.populate(event);
        LOG.debug("Populated repositories");
        LOG.trace("Bootstrapping jobs ...");
        this.jobBootstrapper.bootstrap();
        LOG.debug("Bootstrapped jobs");
        LOG.trace("Scheduling file ingest jobs ...");
        this.fileIngesterJobRegistrar.scheduleJobs();
        LOG.debug("Scheduled file ingest jobs");
        LOG.trace("Bootstrapping ID Card scheduler ...");
        this.idCardBootstrapper.bootstrap();
        LOG.debug("Bootstrapped ID Card scheduler");
        LOG.trace("Bootstrapping annotators ...");
        this.annotatorBootstrapper.bootstrap(event);
        LOG.debug("Bootstrapped annotators");
        LOG.trace("Bootstrapping index ...");
        this.indexBootstrapper.bootstrap();
        LOG.debug("Bootstrapped index");
        LOG.info("Bootstrapping application completed");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

