/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.Objects;
import org.molgenis.auth.UserAuthorityFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.i18n.model.LanguageFactory;
import org.molgenis.framework.db.WebAppDatabasePopulatorService;
import org.molgenis.security.MolgenisSecurityWebAppDatabasePopulatorService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebAppDatabasePopulatorServiceImpl
implements WebAppDatabasePopulatorService {
    private final DataService dataService;
    private final MolgenisSecurityWebAppDatabasePopulatorService molgenisSecurityWebAppDatabasePopulatorService;
    private final UserAuthorityFactory userAuthorityFactory;
    private final LanguageFactory languageFactory;

    @Autowired
    public WebAppDatabasePopulatorServiceImpl(DataService dataService, MolgenisSecurityWebAppDatabasePopulatorService molgenisSecurityWebAppDatabasePopulatorService, UserAuthorityFactory userAuthorityFactory, LanguageFactory languageFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.molgenisSecurityWebAppDatabasePopulatorService = Objects.requireNonNull(molgenisSecurityWebAppDatabasePopulatorService);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.languageFactory = Objects.requireNonNull(languageFactory);
    }

    @Transactional
    @RunAsSystem
    public void populateDatabase() {
        this.molgenisSecurityWebAppDatabasePopulatorService.populateDatabase(this.dataService, "home", "useraccount");
        this.dataService.add("sys_languages", (Entity)this.languageFactory.create("en", "English"));
    }

    @Transactional
    @RunAsSystem
    public boolean isDatabasePopulated() {
        return this.dataService.count("sys_sec_MolgenisUser") > 0L;
    }
}

