/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import freemarker.cache.TemplateLoader;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import org.molgenis.CommandLineOnlyConfiguration;
import org.molgenis.DatabaseConfig;
import org.molgenis.app.WebAppSecurityConfig;
import org.molgenis.data.DataService;
import org.molgenis.data.config.HttpClientConfig;
import org.molgenis.data.elasticsearch.config.EmbeddedElasticSearchConfig;
import org.molgenis.data.system.RepositoryTemplateLoader;
import org.molgenis.dataexplorer.freemarker.DataExplorerHyperlinkDirective;
import org.molgenis.ui.MolgenisWebAppConfig;
import org.molgenis.util.GsonConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableTransactionManagement
@EnableWebMvc
@EnableAsync
@ComponentScan(basePackages={"org.molgenis"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={CommandLineOnlyConfiguration.class})})
@Import(value={WebAppSecurityConfig.class, DatabaseConfig.class, HttpClientConfig.class, EmbeddedElasticSearchConfig.class, GsonConfig.class})
public class WebAppConfig
extends MolgenisWebAppConfig {
    @Autowired
    private DataService dataService;

    protected void addFreemarkerVariables(Map<String, Object> freemarkerVariables) {
        freemarkerVariables.put("dataExplorerLink", new DataExplorerHyperlinkDirective(this.molgenisPluginRegistry(), this.dataService));
    }

    public FreeMarkerConfigurer freeMarkerConfigurer() throws IOException, TemplateException {
        FreeMarkerConfigurer result = super.freeMarkerConfigurer();
        result.setPostTemplateLoaders(new TemplateLoader[]{new RepositoryTemplateLoader(this.dataService)});
        return result;
    }
}

