/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public class BBCompressionUtils {
    private static Logger log = Logger.getLogger(BBCompressionUtils.class);

    public static byte[] decompress(byte[] data2, int uncompressBufSize) {
        byte[] inbuf = data2;
        int rem = data2.length;
        int count2 = 0;
        int off = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(1.5 * (double)inbuf.length));
        byte[] outbuf = new byte[uncompressBufSize];
        while (rem > 0) {
            Inflater decompressor = new Inflater();
            decompressor.setInput(inbuf);
            try {
                uncompressBufSize = outbuf.length;
                count2 = decompressor.inflate(outbuf, 0, uncompressBufSize);
                rem = decompressor.getRemaining();
                if (rem > 0) {
                    inbuf = new byte[rem];
                    System.arraycopy(data2, off += inbuf.length - rem, inbuf, 0, rem);
                    uncompressBufSize -= count2;
                }
                bos.write(outbuf, 0, count2);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] data2, int compressBufSize) {
        Deflater compressor = new Deflater();
        compressor.setLevel(-1);
        compressor.setInput(data2);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data2.length);
        byte[] buf = new byte[compressBufSize];
        while (!compressor.finished()) {
            int count2 = compressor.deflate(buf);
            bos.write(buf, 0, count2);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }
}

