/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.spi.Util;

public class ParallelRunner {
    private int numberOfProcessors;
    private Object key;
    private static final int MINIMUM_BATCH_SIZE = 16;
    private static Map<Object, ParallelRunnableTask> tasks = new IdentityHashMap<Object, ParallelRunnableTask>();

    public ParallelRunner(int numberOfProcessors) {
        assert (numberOfProcessors > 0);
        this.numberOfProcessors = numberOfProcessors;
    }

    public void lock(Object key) {
        ParallelRunner.lock(key, this.numberOfProcessors);
        this.key = key;
    }

    public void unlock() {
        ParallelRunner.unlock(this.key);
    }

    public void runParallel(ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
        if (this.key != null) {
            ParallelRunner.runParallel(this.key, parallelRunnable);
        } else {
            new ParallelRunnableTask(this.numberOfProcessors).run(parallelRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lock(Object key, int numberOfProcessors) {
        assert (numberOfProcessors > 0);
        Map<Object, ParallelRunnableTask> map2 = tasks;
        synchronized (map2) {
            boolean locked = false;
            ParallelRunnableTask addedTask = null;
            while (!locked) {
                ParallelRunnableTask task = tasks.get(key);
                if (task == null) {
                    task = new ParallelRunnableTask(numberOfProcessors);
                    tasks.put(key, task);
                    locked = true;
                    continue;
                }
                if (task != addedTask) {
                    task.add(numberOfProcessors);
                    addedTask = task;
                }
                try {
                    tasks.wait();
                }
                catch (InterruptedException ie) {
                    throw new ApfloatInternalException("Waiting for lock notification was interrupted", ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock(Object key) {
        Map<Object, ParallelRunnableTask> map2 = tasks;
        synchronized (map2) {
            ParallelRunnableTask task = tasks.remove(key);
            assert (task != null);
            tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runParallel(Object key, ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
        ParallelRunnableTask task;
        Map<Object, ParallelRunnableTask> map2 = tasks;
        synchronized (map2) {
            task = tasks.get(key);
            assert (task != null);
        }
        task.run(parallelRunnable);
    }

    private static class ParallelRunnableTask
    implements Runnable {
        private int numberOfProcessors;
        private AtomicReference<ParallelRunnable> parallelRunnable;
        private AtomicInteger position;
        private volatile int batchSize;
        private List<Future<?>> futures;

        public ParallelRunnableTask(int numberOfProcessors) {
            this.numberOfProcessors = numberOfProcessors;
            this.position = new AtomicInteger();
            this.parallelRunnable = new AtomicReference();
        }

        public synchronized void add(int numberOfProcessors) {
            this.numberOfProcessors += numberOfProcessors;
            if (this.parallelRunnable.get() != null) {
                this.submit(numberOfProcessors);
            }
        }

        public void run(ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
            this.start(parallelRunnable);
            this.run();
            this.join();
        }

        public void run() {
            ParallelRunnable parallelRunnable = this.parallelRunnable.get();
            int maxPosition = parallelRunnable.getLength();
            while (this.position.get() < maxPosition) {
                int startValue = this.position.getAndAdd(this.batchSize);
                int length = Math.min(this.batchSize, maxPosition - startValue);
                if (length <= 0) continue;
                Runnable runnable = parallelRunnable.getRunnable(startValue, length);
                runnable.run();
            }
        }

        private synchronized void start(ParallelRunnable parallelRunnable) {
            this.parallelRunnable.set(parallelRunnable);
            this.position.set(0);
            this.batchSize = Math.max(16, Util.sqrt4down(parallelRunnable.getLength()));
            this.submit(this.numberOfProcessors - 1);
        }

        private void submit(int numberOfProcessors) {
            assert (Thread.holdsLock(this));
            if (numberOfProcessors > 0) {
                if (this.futures == null) {
                    this.futures = new ArrayList();
                }
                ApfloatContext ctx = ApfloatContext.getContext();
                ExecutorService executorService = ctx.getExecutorService();
                for (int i = 0; i < numberOfProcessors; ++i) {
                    Future<?> future2 = executorService.submit(this);
                    this.futures.add(future2);
                }
            }
        }

        private synchronized void join() throws ApfloatRuntimeException {
            if (this.futures != null) {
                try {
                    for (Future<?> future2 : this.futures) {
                        future2.get();
                    }
                }
                catch (InterruptedException ie) {
                    throw new ApfloatInternalException("Waiting for dispatched threads to complete was interrupted", ie);
                }
                catch (ExecutionException ee) {
                    throw new ApfloatInternalException("Thread execution failed", ee);
                }
                this.futures = null;
            }
            this.parallelRunnable.set(null);
        }
    }
}

