/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.DoubleFactor3NTTStrategy;
import org.apfloat.internal.DoubleFactor3SixStepNTTStrategy;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.DoubleSixStepFNTStrategy;
import org.apfloat.internal.DoubleTableFNTStrategy;
import org.apfloat.internal.DoubleTwoPassFNTStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleNTTBuilder
implements NTTBuilder {
    public NTTStrategy createNTT(long size2) {
        long power2size;
        ApfloatContext ctx = ApfloatContext.getContext();
        int cacheSize = ctx.getCacheL1Size() / 8;
        long maxMemoryBlockSize = ctx.getMaxMemoryBlockSize() / 8L;
        boolean useFactor3 = false;
        if ((size2 = Util.round23up(size2)) != (power2size = size2 & -size2)) {
            useFactor3 = true;
        }
        DoubleModMath transform2 = power2size <= (long)(cacheSize / 2) ? new DoubleTableFNTStrategy() : (power2size <= maxMemoryBlockSize && power2size <= Integer.MAX_VALUE ? new DoubleSixStepFNTStrategy() : new DoubleTwoPassFNTStrategy());
        if (useFactor3) {
            transform2 = size2 <= maxMemoryBlockSize && size2 <= Integer.MAX_VALUE && transform2 instanceof DoubleSixStepFNTStrategy ? new DoubleFactor3SixStepNTTStrategy((DoubleSixStepFNTStrategy)transform2) : new DoubleFactor3NTTStrategy((NTTStrategy)((Object)transform2));
        }
        return transform2;
    }
}

