/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class BitsStreamGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20130104L;
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] bytes) {
        int random;
        int i;
        int iEnd = bytes.length - 3;
        for (i = 0; i < iEnd; i += 4) {
            random = this.next(32);
            bytes[i] = (byte)(random & 0xFF);
            bytes[i + 1] = (byte)(random >> 8 & 0xFF);
            bytes[i + 2] = (byte)(random >> 16 & 0xFF);
            bytes[i + 3] = (byte)(random >> 24 & 0xFF);
        }
        random = this.next(32);
        while (i < bytes.length) {
            bytes[i++] = (byte)(random & 0xFF);
            random >>= 8;
        }
    }

    public double nextDouble() {
        long high = (long)this.next(26) << 26;
        int low = this.next(26);
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x2 = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x2;
            double r = FastMath.sqrt(-2.0 * FastMath.log(y));
            random = r * FastMath.cos(alpha);
            this.nextGaussian = r * FastMath.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) throws IllegalArgumentException {
        if (n > 0) {
            int val;
            int bits2;
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits2 = this.next(31)) - (val = bits2 % n) + (n - 1) < 0) {
            }
            return val;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public long nextLong() {
        long high = (long)this.next(32) << 32;
        long low = (long)this.next(32) & 0xFFFFFFFFL;
        return high | low;
    }

    public long nextLong(long n) throws IllegalArgumentException {
        if (n > 0L) {
            long bits2;
            long val;
            do {
                bits2 = (long)this.next(31) << 32;
            } while ((bits2 |= (long)this.next(32) & 0xFFFFFFFFL) - (val = bits2 % n) + (n - 1L) < 0L);
            return val;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public void clear() {
        this.nextGaussian = Double.NaN;
    }
}

