/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AssignmentInstruction;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;

final class Assignment
extends TemplateElement {
    private String variableName;
    private Expression value;
    private Expression namespaceExp;
    private int scope;
    static final int NAMESPACE = 1;
    static final int LOCAL = 2;
    static final int GLOBAL = 3;

    Assignment(String variableName, Expression value2, int scope) {
        this.variableName = variableName;
        this.value = value2;
        this.scope = scope;
    }

    void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel tm = this.value.getAsTemplateModel(env);
        Environment.Namespace namespace = null;
        if (this.namespaceExp != null) {
            boolean oops = false;
            try {
                namespace = (Environment.Namespace)this.namespaceExp.getAsTemplateModel(env);
            }
            catch (ClassCastException cce) {
                oops = true;
            }
            if (oops || namespace == null) {
                throw new InvalidReferenceException(this.getStartLocation() + "\nInvalid reference to namespace: " + this.namespaceExp, env);
            }
        }
        if (tm == null) {
            if (env.isClassicCompatible()) {
                tm = TemplateScalarModel.EMPTY_STRING;
            } else {
                String msg = "Error " + this.getStartLocation() + "\n" + this.value + " is undefined." + "\nIt cannot be assigned to " + this.variableName;
                throw new InvalidReferenceException(msg, env);
            }
        }
        if (this.scope == 2) {
            env.setLocalVariable(this.variableName, tm);
        } else {
            if (namespace == null) {
                if (this.scope == 3) {
                    namespace = env.getGlobalNamespace();
                } else if (this.scope == 1) {
                    namespace = env.getCurrentNamespace();
                }
            }
            namespace.put(this.variableName, tm);
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        if (!(this.parent instanceof AssignmentInstruction)) {
            if (this.scope == 2) {
                buf.append("<#local ");
            } else if (this.scope == 3) {
                buf.append("<#global ");
            } else {
                buf.append("<#assign ");
            }
        }
        buf.append(this.variableName);
        buf.append('=');
        buf.append(this.value.getCanonicalForm());
        if (!(this.parent instanceof AssignmentInstruction)) {
            if (this.namespaceExp != null) {
                buf.append(" in ");
                buf.append(this.namespaceExp.getCanonicalForm());
            }
            buf.append(">");
        }
        return buf.toString();
    }

    public String getDescription() {
        String s = "";
        if (!(this.parent instanceof AssignmentInstruction)) {
            s = "assignment: ";
            if (this.scope == 2) {
                s = "local " + s;
            } else if (this.scope == 3) {
                s = "global " + s;
            }
        }
        return s + this.variableName + "=" + this.value;
    }
}

