/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.parameters;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.Priority;
import com.googlecode.charts4j.ShapeMarker;
import com.googlecode.charts4j.TextMarker;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.parameters.AbstractParameter;
import com.googlecode.charts4j.parameters.FillAreaType;
import com.googlecode.charts4j.parameters.ParameterUtil;
import com.googlecode.charts4j.parameters.RangeType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

final class ChartMarkersParameter
extends AbstractParameter {
    private static final String URL_PARAMETER_KEY = "chm";
    private final List<GoogleChartMarker> markers = Lists.newLinkedList();

    ChartMarkersParameter() {
    }

    void addFillAreaMarker(FillAreaType fillAreaType, Color color, int startLineIndex, int endLineIndex) {
        this.markers.add(new FillAreaMarker(fillAreaType, color, startLineIndex, endLineIndex));
    }

    void addLineStyleMarker(Color color, int dataSetIndex, int dataPoint, int size2, Priority priority) {
        this.markers.add(new LineStyleMarker(color, dataSetIndex, dataPoint, size2, priority));
    }

    void addMarker(Marker marker, int dataSetIndex, int startIndex, int endIndex, int n) {
        if (marker instanceof ShapeMarker) {
            this.markers.add(new ShapeMarkerParam((ShapeMarker)marker, dataSetIndex, startIndex, endIndex, n));
        } else if (marker instanceof TextMarker) {
            this.markers.add(new TextMarkerParam((TextMarker)marker, dataSetIndex, startIndex, endIndex, n));
        }
    }

    void addMarkers(Marker marker, int dataSetIndex) {
        this.addMarker(marker, dataSetIndex, -1, 0, 0);
    }

    void addVerticalRangeMarker(Color color, double startPoint, double endPoint) {
        this.markers.add(new RangeMarker(RangeType.VERTICAL, color, startPoint, endPoint));
    }

    void addHorizontalRangeMarker(Color color, double startPoint, double endPoint) {
        this.markers.add(new RangeMarker(RangeType.HORIZONTAL, color, startPoint, endPoint));
    }

    void addFreeMarker(Marker marker, double xPos, double yPos) {
        this.markers.add(new FreeMarker(marker, xPos, yPos));
    }

    public String getKey() {
        return URL_PARAMETER_KEY;
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (GoogleChartMarker m : this.markers) {
            sb.append(cnt++ > 0 ? "|" : "").append(m);
        }
        return !this.markers.isEmpty() ? sb.toString() : "";
    }

    private static class FreeMarker
    implements GoogleChartMarker {
        private final Marker marker;
        private final double xPos;
        private final double yPos;

        private FreeMarker(Marker marker, double xPos, double yPos) {
            this.marker = marker;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public String toString() {
            String s;
            if (this.marker instanceof TextMarker) {
                TextMarker m = (TextMarker)this.marker;
                s = "@" + (m.isFlagged() ? "f" : "t") + m.getText() + "," + m.getColor() + ",0," + this.xPos / 100.0 + ":" + this.yPos / 100.0 + "," + m.getSize() + "," + (Object)((Object)m.getPriority());
            } else if (this.marker instanceof ShapeMarker) {
                ShapeMarker m = (ShapeMarker)this.marker;
                s = "@" + m.getShape().toString() + "," + m.getColor() + ",0," + this.xPos / 100.0 + ":" + this.yPos / 100.0 + "," + m.getSize() + "," + (Object)((Object)m.getPriority());
            } else {
                s = "";
            }
            return s;
        }
    }

    private static final class RangeMarker
    implements GoogleChartMarker {
        private final RangeType rangeType;
        private final Color color;
        private final double startPoint;
        private final double endPoint;
        private final DecimalFormat decimalFormatter = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

        private RangeMarker(RangeType rangeType, Color color, double startPoint, double endPoint) {
            this.rangeType = rangeType;
            this.color = color;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        public String toString() {
            return (Object)((Object)this.rangeType) + "," + this.color + ",0," + this.decimalFormatter.format(this.startPoint) + "," + this.decimalFormatter.format(this.endPoint);
        }
    }

    private static final class FillAreaMarker
    implements GoogleChartMarker {
        private final FillAreaType fillAreaType;
        private final Color color;
        private final int startLineIndex;
        private final int endLineIndex;

        private FillAreaMarker(FillAreaType fillAreaType, Color color, int startLineIndex, int endLineIndex) {
            this.fillAreaType = fillAreaType;
            this.color = color;
            this.startLineIndex = startLineIndex;
            this.endLineIndex = endLineIndex;
        }

        public String toString() {
            return (Object)((Object)this.fillAreaType) + "," + this.color + "," + this.startLineIndex + "," + this.endLineIndex + ",0";
        }
    }

    private static final class TextMarkerParam
    extends GMarker
    implements GoogleChartMarker {
        private TextMarkerParam(TextMarker textMarker, int dataSetIndex, int startIndex, int endIndex, int n) {
            super((textMarker.isFlagged() ? "f" : "t") + ParameterUtil.utf8Encode(textMarker.getText()), textMarker.getColor(), dataSetIndex, startIndex, endIndex, n, textMarker.getSize(), textMarker.getPriority());
        }
    }

    private static final class ShapeMarkerParam
    extends GMarker
    implements GoogleChartMarker {
        private ShapeMarkerParam(ShapeMarker shapeMarker, int dataSetIndex, int startIndex, int endIndex, int n) {
            super(shapeMarker.getShape().toString(), shapeMarker.getColor(), dataSetIndex, startIndex, endIndex, n, shapeMarker.getSize(), shapeMarker.getPriority());
        }
    }

    private static final class LineStyleMarker
    extends GMarker
    implements GoogleChartMarker {
        private LineStyleMarker(Color color, int dataSetIndex, int dataPoint, int size2, Priority priority) {
            super("D", color, dataSetIndex, dataPoint, dataPoint + 1, 1, size2, priority);
        }
    }

    private static class GMarker
    implements GoogleChartMarker {
        private final String marker;
        private final Color color;
        private final int dataSetIndex;
        private final int startIndex;
        private final int endIndex;
        private final int n;
        private final int size;
        private final Priority priority;

        private GMarker(String marker, Color color, int dataSetIndex, int startIndex, int endIndex, int n, int size2, Priority priority) {
            this.marker = marker;
            this.color = color;
            this.dataSetIndex = dataSetIndex;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.n = n;
            this.size = size2;
            this.priority = priority;
        }

        public String toString() {
            String returnString = this.startIndex >= 0 && this.endIndex == this.startIndex + 1 ? this.marker + "," + this.color + "," + this.dataSetIndex + "," + this.startIndex + "," + this.size + "," + (Object)((Object)this.priority) : (this.startIndex == -1 ? this.marker + "," + this.color + "," + this.dataSetIndex + "," + this.startIndex + "," + this.size + "," + (Object)((Object)this.priority) : this.marker + "," + this.color + "," + this.dataSetIndex + "," + this.startIndex + ":" + (this.endIndex - 1) + ":" + this.n + "," + this.size + "," + (Object)((Object)this.priority));
            return returnString;
        }
    }

    private static interface GoogleChartMarker {
    }
}

