/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class VcfLof {
    String geneName;
    String geneId;
    int numTranscripts;
    double percentAffected;

    public static int fieldNum(String name) {
        int fieldNum = 0;
        if (name.equals("LOF.GENE")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.GENEID")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.NUMTR")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.PERC")) {
            return fieldNum;
        }
        ++fieldNum;
        return -1;
    }

    public VcfLof(Gene gene, double percentAffected) {
        this.geneName = gene.getGeneName();
        this.geneId = gene.getId();
        this.numTranscripts = gene.numChilds();
        this.percentAffected = percentAffected;
    }

    public VcfLof(String lofStr) {
        this.parse(lofStr);
    }

    public VcfLof(String geneName, String geneId, int numTranscripts, double percentAffected) {
        this.geneName = geneName;
        this.geneId = geneId;
        this.numTranscripts = numTranscripts;
        this.percentAffected = percentAffected;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public int getNumTranscripts() {
        return this.numTranscripts;
    }

    public double getPercentAffected() {
        return this.percentAffected;
    }

    void parse(String lof) {
        if (lof.startsWith("(")) {
            lof = lof.substring(1);
        }
        if (lof.endsWith(")")) {
            lof = lof.substring(0, lof.length() - 1);
        }
        String[] lofFields = lof.split("\\|");
        try {
            int index = 0;
            if (lofFields.length > index && !lofFields[index].isEmpty()) {
                this.geneName = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.geneId = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.numTranscripts = Gpr.parseIntSafe(lofFields[index]);
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.percentAffected = Gpr.parseDoubleSafe(lofFields[index]);
            }
            ++index;
        }
        catch (Exception e) {
            String fields = "";
            for (int i = 0; i < lofFields.length; ++i) {
                fields = fields + "\t" + i + " : '" + lofFields[i] + "'\n";
            }
            throw new RuntimeException("Error parsing: '" + lof + "'\n" + fields, e);
        }
    }

    public String toString() {
        return String.format("(%s|%s|%d|%.2f)", VcfEntry.vcfInfoSafe(this.geneName), VcfEntry.vcfInfoSafe(this.geneId), this.numTranscripts, this.percentAffected);
    }
}

