/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.PedigreeEnrty;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfoGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VcfHeader {
    public static final String INFO_PREFIX = "##INFO=";
    public static final String FORMAT_PREFIX = "##FORMAT=";
    public static final String PEDIGREE_PREFIX = "##PEDIGREE=";
    public static final String CHROM_PREFIX = "#CHROM\t";
    int numberOfSamples = -1;
    StringBuffer header = new StringBuffer();
    Map<String, VcfHeaderInfo> vcfInfoById;
    Map<String, VcfHeaderInfoGenotype> vcfInfoGenotypeById;
    ArrayList<String> sampleNames;
    Map<String, Integer> sampleName2Num;
    boolean chromLine = false;

    public void add(VcfHeaderEntry vcfInfo) {
        this.parseInfoLines();
        if (this.vcfInfoById.containsKey(vcfInfo.getId())) {
            this.removeInfo(vcfInfo.getId());
        }
        this.addLine(vcfInfo.toString());
        this.resetCache();
    }

    public void addFormat(VcfHeaderInfoGenotype vcfInfoGenotype) {
        this.parseInfoLines();
        if (!this.vcfInfoGenotypeById.containsKey(vcfInfoGenotype.getId())) {
            this.addLine(vcfInfoGenotype.toString());
            this.resetCache();
        }
    }

    public void addLine(String newHeaderLine) {
        if (newHeaderLine == null) {
            return;
        }
        if (this.chromLine) {
            String[] headerLines = this.header.toString().split("\n");
            this.header = new StringBuffer();
            boolean added = false;
            for (String line : headerLines) {
                if (!added) {
                    if (line.equals(newHeaderLine)) {
                        added = true;
                    } else if (line.startsWith(CHROM_PREFIX)) {
                        this.header.append(newHeaderLine + "\n");
                        added = true;
                    }
                }
                if (line.isEmpty()) continue;
                this.header.append(line + "\n");
            }
            if (!added) {
                this.header.append(newHeaderLine + "\n");
            }
        } else {
            this.appendNewLineToHeader();
            this.header.append(newHeaderLine);
            this.chromLine |= newHeaderLine.startsWith(CHROM_PREFIX);
        }
        this.resetCache();
    }

    void appendNewLineToHeader() {
        int lastChar;
        int n = lastChar = this.header.length() > 0 ? (int)this.header.charAt(this.header.length() - 1) : 10;
        if (lastChar != 10 && lastChar != 13) {
            this.header.append('\n');
        }
    }

    public String[] getLines() {
        return this.header.toString().split("\n");
    }

    public int getNumberOfSamples() {
        if (this.numberOfSamples < 0) {
            this.getSampleNames();
            this.numberOfSamples = this.sampleNames != null ? this.sampleNames.size() : 0;
        }
        return this.numberOfSamples;
    }

    public List<PedigreeEnrty> getPedigree() {
        ArrayList<PedigreeEnrty> list2 = new ArrayList<PedigreeEnrty>();
        List<String> sampleNames = this.getSampleNames();
        if (sampleNames.isEmpty()) {
            Gpr.debug("Error: Could not get sample names");
            return list2;
        }
        for (String line : this.getLines()) {
            if (!line.startsWith(PEDIGREE_PREFIX)) continue;
            String l = line.substring(PEDIGREE_PREFIX.length());
            l = l.replace('<', ' ');
            l = l.replace('>', ' ');
            String[] records = (l = l.trim()).split(",");
            if (records.length == 2) {
                String derived = null;
                String original = null;
                for (String r : records) {
                    String[] nv = r.split("=");
                    String name = nv[0];
                    String value2 = nv[1];
                    if (name.equalsIgnoreCase("Derived")) {
                        derived = value2;
                        continue;
                    }
                    if (name.equalsIgnoreCase("Original")) {
                        original = value2;
                        continue;
                    }
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Field name: '" + name + "'\n\tLine: '" + line + "'");
                }
                if (derived == null) {
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Missing 'Derived' name-value pair");
                }
                if (original == null) {
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Missing 'Original' name-value pair");
                }
                PedigreeEnrty pe = new PedigreeEnrty(original, derived);
                pe.sampleNumbers(sampleNames);
                list2.add(pe);
                continue;
            }
            if (records.length == 2) {
                String father = null;
                String mother = null;
                String child = null;
                for (String r : records) {
                    String[] nv = r.split("=");
                    String name = nv[0];
                    String value3 = nv[1];
                    if (name.equalsIgnoreCase("Father")) {
                        father = value3;
                        continue;
                    }
                    if (name.equalsIgnoreCase("Mother")) {
                        mother = value3;
                        continue;
                    }
                    if (name.equalsIgnoreCase("Child")) {
                        child = value3;
                        continue;
                    }
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Field name: '" + name + "'\n\tLine: '" + line + "'");
                }
                if (father == null) {
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Missing 'Father' name-value pair");
                }
                if (mother == null) {
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Missing 'Mother' name-value pair");
                }
                if (child == null) {
                    throw new RuntimeException("Cannot parse PEDIGREE heade line. Missing 'Child' name-value pair");
                }
                PedigreeEnrty pe = new PedigreeEnrty(father, mother, child);
                pe.sampleNumbers(sampleNames);
                list2.add(pe);
                continue;
            }
            throw new RuntimeException("Unable to parse pedigree line:\n\t'" + line + "'");
        }
        return list2;
    }

    public List<String> getSampleNames() {
        String[] headerLines;
        if (this.sampleNames != null) {
            return this.sampleNames;
        }
        for (String line : headerLines = this.header.toString().split("\n")) {
            if (!line.startsWith("#CHROM")) continue;
            this.chromLine = true;
            String[] titles = line.split("\t");
            this.sampleNames = new ArrayList();
            for (int i = 9; i < titles.length; ++i) {
                this.sampleNames.add(titles[i]);
            }
            return this.sampleNames;
        }
        return null;
    }

    public int getSampleNum(String sameplName) {
        Integer num;
        if (this.sampleName2Num == null) {
            this.sampleName2Num = new HashMap<String, Integer>();
            int count2 = 0;
            if (this.getSampleNames() != null) {
                for (String name : this.getSampleNames()) {
                    this.sampleName2Num.put(name, count2++);
                }
            }
        }
        return (num = this.sampleName2Num.get(sameplName)) != null ? num : -1;
    }

    public Collection<VcfHeaderInfo> getVcfInfo() {
        this.parseInfoLines();
        return this.vcfInfoById.values();
    }

    public VcfHeaderInfo getVcfInfo(String id) {
        this.parseInfoLines();
        return this.vcfInfoById.get(id);
    }

    public Map<String, VcfHeaderInfo> getVcfInfoById() {
        this.parseInfoLines();
        return this.vcfInfoById;
    }

    public VcfHeaderInfoGenotype getVcfInfoGenotype(String id) {
        this.parseInfoLines();
        return this.vcfInfoGenotypeById.get(id);
    }

    public void parseInfoLines() {
        if (this.vcfInfoById != null) {
            return;
        }
        this.chromLine = this.header.indexOf(CHROM_PREFIX) >= 0;
        this.vcfInfoById = new HashMap<String, VcfHeaderInfo>();
        this.vcfInfoById.put("CHROM", new VcfHeaderInfo("CHROM", VcfInfoType.String, "1", "Chromosome name"));
        this.vcfInfoById.put("POS", new VcfHeaderInfo("POS", VcfInfoType.Integer, "1", "Position in chromosome"));
        this.vcfInfoById.put("ID", new VcfHeaderInfo("ID", VcfInfoType.String, "1", "Variant ID"));
        this.vcfInfoById.put("REF", new VcfHeaderInfo("REF", VcfInfoType.String, "1", "Reference sequence"));
        this.vcfInfoById.put("ALT", new VcfHeaderInfo("ALT", VcfInfoType.String, "A", "Alternative sequence/s"));
        this.vcfInfoById.put("QUAL", new VcfHeaderInfo("QUAL", VcfInfoType.Float, "1", "Mapping quality"));
        this.vcfInfoById.put("FILTER", new VcfHeaderInfo("FILTER", VcfInfoType.String, "1", "Filter status"));
        this.vcfInfoById.put("FORMAT", new VcfHeaderInfo("FORMAT", VcfInfoType.String, "1", "Format in genotype fields"));
        this.vcfInfoById.put("AA", new VcfHeaderInfo("AA", VcfInfoType.String, "1", "Ancestral allele"));
        this.vcfInfoById.put("AC", new VcfHeaderInfo("AC", VcfInfoType.Integer, "A", "Allele Frequency"));
        this.vcfInfoById.put("AF", new VcfHeaderInfo("AF", VcfInfoType.Float, "1", "Allele Frequency"));
        this.vcfInfoById.put("AN", new VcfHeaderInfo("AN", VcfInfoType.Integer, "1", "Total number of alleles"));
        this.vcfInfoById.put("BQ", new VcfHeaderInfo("BQ", VcfInfoType.Float, "1", "RMS base quality"));
        this.vcfInfoById.put("CIGAR", new VcfHeaderInfo("CIGAR", VcfInfoType.String, "1", "Cigar string describing how to align an alternate allele to the reference allele"));
        this.vcfInfoById.put("DB", new VcfHeaderInfo("DB", VcfInfoType.Flag, "1", "dbSNP membership"));
        this.vcfInfoById.put("DP", new VcfHeaderInfo("DP", VcfInfoType.Integer, "1", "Combined depth across samples"));
        this.vcfInfoById.put("END", new VcfHeaderInfo("END", VcfInfoType.String, "1", "End position of the variant described in this record"));
        this.vcfInfoById.put("H2", new VcfHeaderInfo("H2", VcfInfoType.Flag, "1", "Membership in hapmap 2"));
        this.vcfInfoById.put("H3", new VcfHeaderInfo("H3", VcfInfoType.Flag, "1", "Membership in hapmap 3"));
        this.vcfInfoById.put("MQ", new VcfHeaderInfo("MQ", VcfInfoType.Float, "1", "RMS mapping quality"));
        this.vcfInfoById.put("MQ0", new VcfHeaderInfo("MQ0", VcfInfoType.Integer, "1", "Number of MAPQ == 0 reads covering this record"));
        this.vcfInfoById.put("NS", new VcfHeaderInfo("NS", VcfInfoType.Integer, "1", "Number of samples with data"));
        this.vcfInfoById.put("SB", new VcfHeaderInfo("SB", VcfInfoType.Float, "1", "Strand bias at this position"));
        this.vcfInfoById.put("SOMATIC", new VcfHeaderInfo("SOMATIC", VcfInfoType.Flag, "1", "Indicates that the record is a somatic mutation, for cancer genomics"));
        this.vcfInfoById.put("VALIDATED", new VcfHeaderInfo("VALIDATED", VcfInfoType.Flag, "1", "Validated by follow-up experiment"));
        this.vcfInfoById.put("1000G", new VcfHeaderInfo("1000G", VcfInfoType.Flag, "1", "Membership in 1000 Genomes"));
        this.vcfInfoById.put("IMPRECISE", new VcfHeaderInfo("IMPRECISE", VcfInfoType.Flag, "0", "Imprecise structural variation"));
        this.vcfInfoById.put("NOVEL", new VcfHeaderInfo("NOVEL", VcfInfoType.Flag, "0", "Indicates a novel structural variation"));
        this.vcfInfoById.put("END", new VcfHeaderInfo("END", VcfInfoType.Integer, "1", "End position of the variant described in this record"));
        this.vcfInfoById.put("SVTYPE", new VcfHeaderInfo("SVTYPE", VcfInfoType.String, "1", "Type of structural variant"));
        this.vcfInfoById.put("SVLEN", new VcfHeaderInfo("SVLEN", VcfInfoType.Integer, ".", "Difference in length between REF and ALT alleles"));
        this.vcfInfoById.put("CIPOS", new VcfHeaderInfo("CIPOS", VcfInfoType.Integer, "2", "Confidence interval around POS for imprecise variants"));
        this.vcfInfoById.put("CIEND", new VcfHeaderInfo("CIEND", VcfInfoType.Integer, "2", "Confidence interval around END for imprecise variants"));
        this.vcfInfoById.put("HOMLEN", new VcfHeaderInfo("HOMLEN", VcfInfoType.Integer, ".", "Length of base pair identical micro-homology at event breakpoints"));
        this.vcfInfoById.put("HOMSEQ", new VcfHeaderInfo("HOMSEQ", VcfInfoType.String, ".", "Sequence of base pair identical micro-homology at event breakpoints"));
        this.vcfInfoById.put("BKPTID", new VcfHeaderInfo("BKPTID", VcfInfoType.String, ".", "ID of the assembled alternate allele in the assembly file"));
        this.vcfInfoById.put("MEINFO", new VcfHeaderInfo("MEINFO", VcfInfoType.String, "4", "Mobile element info of the form NAME,START,END,POLARITY"));
        this.vcfInfoById.put("METRANS", new VcfHeaderInfo("METRANS", VcfInfoType.String, "4", "Mobile element transduction info of the form CHR,START,END,POLARITY"));
        this.vcfInfoById.put("DGVID", new VcfHeaderInfo("DGVID", VcfInfoType.String, "1", "ID of this element in Database of Genomic Variation"));
        this.vcfInfoById.put("DBVARID", new VcfHeaderInfo("DBVARID", VcfInfoType.String, "1", "ID of this element in DBVAR"));
        this.vcfInfoById.put("DBRIPID", new VcfHeaderInfo("DBRIPID", VcfInfoType.String, "1", "ID of this element in DBRIP"));
        this.vcfInfoById.put("MATEID", new VcfHeaderInfo("MATEID", VcfInfoType.String, ".", "ID of mate breakends"));
        this.vcfInfoById.put("PARID", new VcfHeaderInfo("PARID", VcfInfoType.String, "1", "ID of partner breakend"));
        this.vcfInfoById.put("EVENT", new VcfHeaderInfo("EVENT", VcfInfoType.String, "1", "ID of event associated to breakend"));
        this.vcfInfoById.put("CILEN", new VcfHeaderInfo("CILEN", VcfInfoType.Integer, "2", "Confidence interval around the length of the inserted material between breakends"));
        this.vcfInfoById.put("DP", new VcfHeaderInfo("DP", VcfInfoType.Integer, "1", "Read Depth of segment containing breakend"));
        this.vcfInfoById.put("DPADJ", new VcfHeaderInfo("DPADJ", VcfInfoType.Integer, ".", "Read Depth of adjacency"));
        this.vcfInfoById.put("CN", new VcfHeaderInfo("CN", VcfInfoType.Integer, "1", "Copy number of segment containing breakend"));
        this.vcfInfoById.put("CNADJ", new VcfHeaderInfo("CNADJ", VcfInfoType.Integer, ".", "Copy number of adjacency"));
        this.vcfInfoById.put("CICN", new VcfHeaderInfo("CICN", VcfInfoType.Integer, "2", "Confidence interval around copy number for the segment"));
        this.vcfInfoById.put("CICNADJ", new VcfHeaderInfo("CICNADJ", VcfInfoType.Integer, ".", "Confidence interval around copy number for the adjacency"));
        String eff = "EFF";
        this.vcfInfoById.put(eff + ".EFFECT", new VcfHeaderInfo(eff + ".EFFECT", VcfInfoType.String, ".", "SnpEff effect"));
        this.vcfInfoById.put(eff + ".IMPACT", new VcfHeaderInfo(eff + ".IMPACT", VcfInfoType.String, ".", "SnpEff impact (HIGH, MODERATE, LOW, MODIFIER)"));
        this.vcfInfoById.put(eff + ".FUNCLASS", new VcfHeaderInfo(eff + ".FUNCLASS", VcfInfoType.String, ".", "SnpEff functional class (NONE, SILENT, MISSENSE, NONSENSE)"));
        this.vcfInfoById.put(eff + ".CODON", new VcfHeaderInfo(eff + ".CODON", VcfInfoType.String, ".", "SnpEff codon change"));
        this.vcfInfoById.put(eff + ".AA", new VcfHeaderInfo(eff + ".AA", VcfInfoType.String, ".", "SnpEff amino acid change"));
        this.vcfInfoById.put(eff + ".AA_LEN", new VcfHeaderInfo(eff + ".AA_LEN", VcfInfoType.Integer, ".", "Protein length in amino acids"));
        this.vcfInfoById.put(eff + ".GENE", new VcfHeaderInfo(eff + ".GENE", VcfInfoType.String, ".", "SnpEff gene name"));
        this.vcfInfoById.put(eff + ".BIOTYPE", new VcfHeaderInfo(eff + ".BIOTYPE", VcfInfoType.String, ".", "SnpEff gene bio-type"));
        this.vcfInfoById.put(eff + ".CODING", new VcfHeaderInfo(eff + ".CODING", VcfInfoType.String, ".", "SnpEff gene coding (CODING, NON_CODING)"));
        this.vcfInfoById.put(eff + ".TRID", new VcfHeaderInfo(eff + ".TRID", VcfInfoType.String, ".", "SnpEff transcript ID"));
        this.vcfInfoById.put(eff + ".RANK", new VcfHeaderInfo(eff + ".RANK", VcfInfoType.String, ".", "SnpEff exon/intron rank"));
        this.vcfInfoById.put(eff + ".EXID", new VcfHeaderInfo(eff + ".EXID", VcfInfoType.String, ".", "SnpEff exon ID"));
        this.vcfInfoById.put(eff + ".GENOTYPE", new VcfHeaderInfo(eff + ".GENOTYPE", VcfInfoType.String, ".", "SnpEff genotype"));
        this.vcfInfoById.put(eff + ".GT", new VcfHeaderInfo(eff + ".GT", VcfInfoType.String, ".", "SnpEff genotype"));
        this.vcfInfoById.put(eff + ".GENOTYPE_NUMBER", new VcfHeaderInfo(eff + ".GENOTYPE_NUMBER", VcfInfoType.String, ".", "SnpEff genotype"));
        this.vcfInfoById.put(eff + ".ERRORS", new VcfHeaderInfo(eff + ".ERRORS", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
        this.vcfInfoById.put(eff + ".WARNINGS", new VcfHeaderInfo(eff + ".WARNINGS", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
        this.vcfInfoById.put(eff + ".INFOS", new VcfHeaderInfo(eff + ".INFO", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
        for (String ann : EffFormatVersion.VCF_INFO_ANN_NAMES) {
            this.vcfInfoById.put(ann + ".ALLELE", new VcfHeaderInfo(ann + ".ALLELE", VcfInfoType.String, ".", "SnpEff genotype"));
            this.vcfInfoById.put(ann + ".GENOTYPE", new VcfHeaderInfo(ann + ".GENOTYPE", VcfInfoType.String, ".", "SnpEff genotype"));
            this.vcfInfoById.put(ann + ".GT", new VcfHeaderInfo(ann + ".GT", VcfInfoType.String, ".", "SnpEff genotype"));
            this.vcfInfoById.put(ann + ".EFFECT", new VcfHeaderInfo(ann + ".EFFECT", VcfInfoType.String, ".", "SnpEff effect"));
            this.vcfInfoById.put(ann + ".ANNOTATION", new VcfHeaderInfo(ann + ".ANNOTATION", VcfInfoType.String, ".", "SnpEff annotation"));
            this.vcfInfoById.put(ann + ".IMPACT", new VcfHeaderInfo(ann + ".IMPACT", VcfInfoType.String, ".", "SnpEff impact (HIGH, MODERATE, LOW, MODIFIER)"));
            this.vcfInfoById.put(ann + ".GENE", new VcfHeaderInfo(ann + ".GENE", VcfInfoType.String, ".", "SnpEff gene name"));
            this.vcfInfoById.put(ann + ".GENEID", new VcfHeaderInfo(ann + ".GENEID", VcfInfoType.String, ".", "SnpEff gene ID"));
            this.vcfInfoById.put(ann + ".FEATURE", new VcfHeaderInfo(ann + ".FEATURE", VcfInfoType.String, ".", "SnpEff feature type"));
            this.vcfInfoById.put(ann + ".FEATUREID", new VcfHeaderInfo(ann + ".FEATUREID", VcfInfoType.String, ".", "SnpEff feature ID"));
            this.vcfInfoById.put(ann + ".TRID", new VcfHeaderInfo(ann + ".TRID", VcfInfoType.String, ".", "SnpEff feature ID"));
            this.vcfInfoById.put(ann + ".BIOTYPE", new VcfHeaderInfo(ann + ".BIOTYPE", VcfInfoType.String, ".", "SnpEff gene bio-type"));
            this.vcfInfoById.put(ann + ".RANK", new VcfHeaderInfo(ann + ".RANK", VcfInfoType.String, ".", "SnpEff exon/intron rank"));
            this.vcfInfoById.put(ann + ".EXID", new VcfHeaderInfo(ann + ".EXID", VcfInfoType.String, ".", "SnpEff exon ID"));
            this.vcfInfoById.put(ann + ".CODON", new VcfHeaderInfo(ann + ".CODON", VcfInfoType.String, ".", "SnpEff codon change"));
            this.vcfInfoById.put(ann + ".HGVS_DNA", new VcfHeaderInfo(ann + ".HGVS_DNA", VcfInfoType.String, ".", "SnpEff HGVS DNA"));
            this.vcfInfoById.put(ann + ".HGVS_C", new VcfHeaderInfo(ann + ".HGVS_C", VcfInfoType.String, ".", "SnpEff HGVS DNA"));
            this.vcfInfoById.put(ann + ".AA", new VcfHeaderInfo(ann + ".AA", VcfInfoType.String, ".", "SnpEff amino acid change"));
            this.vcfInfoById.put(ann + ".HGVS", new VcfHeaderInfo(ann + ".HGVS", VcfInfoType.String, ".", "SnpEff HGVS protein notation"));
            this.vcfInfoById.put(ann + ".HGVS_P", new VcfHeaderInfo(ann + ".HGVS_P", VcfInfoType.String, ".", "SnpEff HGVS protein notation"));
            this.vcfInfoById.put(ann + ".HGVS_PROT", new VcfHeaderInfo(ann + ".HGVS_PROT", VcfInfoType.String, ".", "SnpEff HGVS protein notation"));
            this.vcfInfoById.put(ann + ".AA_LEN", new VcfHeaderInfo(ann + ".AA_LEN", VcfInfoType.Integer, ".", "Protein length in amino acids"));
            this.vcfInfoById.put(ann + ".LEN_AA", new VcfHeaderInfo(ann + ".LEN_AA", VcfInfoType.Integer, ".", "Protein length in amino acids"));
            this.vcfInfoById.put(ann + ".POS_AA", new VcfHeaderInfo(ann + ".POS_AA", VcfInfoType.Integer, ".", "Variant's position within protein"));
            this.vcfInfoById.put(ann + ".AA_POS", new VcfHeaderInfo(ann + ".AA_POS", VcfInfoType.Integer, ".", "Variant's position within protein"));
            this.vcfInfoById.put(ann + ".CDNA_LEN", new VcfHeaderInfo(ann + ".CDNA_LEN", VcfInfoType.Integer, ".", "cDNA length"));
            this.vcfInfoById.put(ann + ".LEN_CDNA", new VcfHeaderInfo(ann + ".LEN_CDNA", VcfInfoType.Integer, ".", "cDNA length"));
            this.vcfInfoById.put(ann + ".POS_CDNA", new VcfHeaderInfo(ann + ".POS_CDNA", VcfInfoType.Integer, ".", "Variant's position within cDNA"));
            this.vcfInfoById.put(ann + ".CDNA_POS", new VcfHeaderInfo(ann + ".CDNA_POS", VcfInfoType.Integer, ".", "Variant's position within cDNA"));
            this.vcfInfoById.put(ann + ".CDS_LEN", new VcfHeaderInfo(ann + ".CDS_LEN", VcfInfoType.Integer, ".", "CDS length"));
            this.vcfInfoById.put(ann + ".LEN_CDS", new VcfHeaderInfo(ann + ".LEN_CDS", VcfInfoType.Integer, ".", "CSD length"));
            this.vcfInfoById.put(ann + ".POS_CDS", new VcfHeaderInfo(ann + ".POS_CDS", VcfInfoType.Integer, ".", "Variant's position within CDS"));
            this.vcfInfoById.put(ann + ".CDS_POS", new VcfHeaderInfo(ann + ".CDS_POS", VcfInfoType.Integer, ".", "Variant's position within CDS"));
            this.vcfInfoById.put(ann + ".DISTANCE", new VcfHeaderInfo(ann + ".DISTANCE", VcfInfoType.Integer, ".", "Distance"));
            this.vcfInfoById.put(ann + ".ERRORS", new VcfHeaderInfo(ann + ".ERRORS", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
            this.vcfInfoById.put(ann + ".WARNINGS", new VcfHeaderInfo(ann + ".WARNINGS", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
            this.vcfInfoById.put(ann + ".INFOS", new VcfHeaderInfo(ann + ".INFO", VcfInfoType.String, ".", "Errors, Warnings or additional Information"));
        }
        this.vcfInfoById.put("LOF.GENE", new VcfHeaderInfo("LOF.GENE", VcfInfoType.String, ".", "SnpEff LOF gene name"));
        this.vcfInfoById.put("LOF.GENEID", new VcfHeaderInfo("LOF.GENEID", VcfInfoType.String, ".", "SnpEff LOF gene ID"));
        this.vcfInfoById.put("LOF.NUMTR", new VcfHeaderInfo("LOF.NUMTR", VcfInfoType.Integer, ".", "SnpEff LOF number of transcripts in gene"));
        this.vcfInfoById.put("LOF.PERC", new VcfHeaderInfo("LOF.PERC", VcfInfoType.Float, ".", "SnpEff LOF percentage of transcripts in this gene that are affected"));
        this.vcfInfoById.put("NMD.GENE", new VcfHeaderInfo("NMD.GENE", VcfInfoType.String, ".", "SnpEff NMD gene name"));
        this.vcfInfoById.put("NMD.GENEID", new VcfHeaderInfo("NMD.GENEID", VcfInfoType.String, ".", "SnpEff NMD gene ID"));
        this.vcfInfoById.put("NMD.NUMTR", new VcfHeaderInfo("NMD.NUMTR", VcfInfoType.Integer, ".", "SnpEff NMD number of transcripts in gene"));
        this.vcfInfoById.put("NMD.PERC", new VcfHeaderInfo("NMD.PERC", VcfInfoType.Float, ".", "SnpEff NMD percentage of transcripts in this gene that are affected"));
        this.vcfInfoGenotypeById = new HashMap<String, VcfHeaderInfoGenotype>();
        this.vcfInfoGenotypeById.put("DP", new VcfHeaderInfoGenotype("DP", VcfInfoType.Integer, "1", "Read depth"));
        this.vcfInfoGenotypeById.put("EC", new VcfHeaderInfoGenotype("EC", VcfInfoType.Integer, "A", "Expected alternate allele counts"));
        this.vcfInfoGenotypeById.put("FT", new VcfHeaderInfoGenotype("FT", VcfInfoType.String, "1", "Genotype filter"));
        this.vcfInfoGenotypeById.put("GT", new VcfHeaderInfoGenotype("GT", VcfInfoType.String, "1", "Genotype"));
        this.vcfInfoGenotypeById.put("GP", new VcfHeaderInfoGenotype("GP", VcfInfoType.Float, "1", "Genotype phred-scaled genotype posterior probabilities"));
        this.vcfInfoGenotypeById.put("GQ", new VcfHeaderInfoGenotype("GQ", VcfInfoType.Integer, "1", "Genotype conditional genotype quality, encoded as a phred quality"));
        this.vcfInfoGenotypeById.put("HQ", new VcfHeaderInfoGenotype("HQ", VcfInfoType.Integer, "2", "Haplotype qualities"));
        this.vcfInfoGenotypeById.put("PL", new VcfHeaderInfoGenotype("PL", VcfInfoType.String, "G", "Normalized, Phred-scaled likelihoods for genotypes"));
        this.vcfInfoGenotypeById.put("PQ", new VcfHeaderInfoGenotype("PQ", VcfInfoType.Integer, "1", "Phasing quality"));
        this.vcfInfoGenotypeById.put("PS", new VcfHeaderInfoGenotype("PS", VcfInfoType.Integer, "1", "Phase set"));
        this.vcfInfoGenotypeById.put("MQ", new VcfHeaderInfoGenotype("MQ", VcfInfoType.Integer, "1", "RMS mapping quality."));
        for (VcfHeaderInfo vcfInfo : this.vcfInfoById.values()) {
            vcfInfo.setImplicit(true);
        }
        for (VcfHeaderInfoGenotype vcfInfoGenotype : this.vcfInfoGenotypeById.values()) {
            vcfInfoGenotype.setImplicit(true);
        }
        for (String line : this.getLines()) {
            if (!line.startsWith(INFO_PREFIX) && !line.startsWith(FORMAT_PREFIX)) continue;
            VcfHeaderInfo vcfInfo = (VcfHeaderInfo)VcfHeaderEntry.factory(line);
            if (vcfInfo instanceof VcfHeaderInfoGenotype) {
                this.vcfInfoGenotypeById.put(vcfInfo.getId(), (VcfHeaderInfoGenotype)vcfInfo);
                continue;
            }
            this.vcfInfoById.put(vcfInfo.getId(), vcfInfo);
        }
    }

    public void remove(String linePrefix) {
        String[] headerLines = this.header.toString().split("\n");
        this.header = new StringBuffer();
        for (String line : headerLines) {
            if (line.startsWith(linePrefix) || line.isEmpty()) continue;
            this.header.append(line + "\n");
        }
        this.appendNewLineToHeader();
    }

    public void removeInfo(String infoId) {
        String[] headerLines = this.header.toString().split("\n");
        this.header = new StringBuffer();
        for (String line : headerLines) {
            VcfHeaderInfo vhinfo;
            if ((line.startsWith(INFO_PREFIX) || line.startsWith(FORMAT_PREFIX)) && (vhinfo = (VcfHeaderInfo)VcfHeaderEntry.factory(line)).getId().equals(infoId) || line.isEmpty()) continue;
            this.header.append(line + "\n");
        }
        this.appendNewLineToHeader();
    }

    void resetCache() {
        this.vcfInfoById = null;
        this.vcfInfoGenotypeById = null;
    }

    public String toString() {
        if (this.header.length() <= 0) {
            return "";
        }
        char c = this.header.charAt(this.header.length() - 1);
        while (c == '\n' || c == '\r') {
            this.header.deleteCharAt(this.header.length() - 1);
            c = this.header.charAt(this.header.length() - 1);
        }
        return this.header.toString();
    }
}

