/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import java.util.HashMap;
import java.util.Map;

public class VcfConsequenceHeader {
    VcfHeaderInfo vcfInfoCsq;
    String[] fieldNames;
    Map<String, Integer> fieldNum;

    public VcfConsequenceHeader(VcfFileIterator vcf) {
        this.parseCsqHeader(vcf);
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Integer getFieldNum(String fieldName) {
        return this.fieldNum.get(fieldName);
    }

    void parseCsqHeader(VcfFileIterator vcf) {
        this.vcfInfoCsq = vcf.getVcfHeader().getVcfInfo("CSQ");
        if (this.vcfInfoCsq == null) {
            throw new RuntimeException("Cannot find CSQ in VCF header");
        }
        String descr = this.vcfInfoCsq.getDescription();
        String fields = descr.substring(descr.lastIndexOf(58) + 1);
        this.fieldNames = fields.split("\\|");
        this.fieldNum = new HashMap<String, Integer>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.fieldNames[i] = this.fieldNames[i].trim();
            this.fieldNum.put(this.fieldNames[i], i);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.fieldNames) {
            sb.append("Field '" + name + "', number " + this.getFieldNum(name) + "\n");
        }
        return sb.toString();
    }
}

