/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.util;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Random;

public class GprSeq {
    public static final char FASTQ_SANGER_ZERO = '!';
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final char[] AMINO_ACIDS = new char[]{'A', 'R', 'N', 'D', 'C', 'E', 'Q', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    public static byte[] AA_TO_CODE;
    public static char[] CODE_TO_AA;
    public static byte[] DNA_TO_CODE;
    public static char[] CODE_TO_DNA;
    public static final byte GAP_CODE = -1;
    public static final String[] KNOWN_FILE_EXTENSIONS;

    public static byte aa2Code(char aa) {
        if (aa == '-') {
            return -1;
        }
        byte c = AA_TO_CODE[(byte)aa];
        if (c < 0) {
            throw new RuntimeException("Unknown code for amino acid '" + aa + "' (ord: " + aa + " )");
        }
        return c;
    }

    public static byte[] aa2Code(String aa) {
        byte[] codes = new byte[aa.length()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = GprSeq.aa2Code(aa.charAt(i));
        }
        return codes;
    }

    public static int aaPairCode(byte aaCode1, byte aaCode2) {
        if (aaCode1 < 0 || aaCode2 < 0) {
            return -1;
        }
        return aaCode1 * AMINO_ACIDS.length + aaCode2;
    }

    public static int aaPairCode(char aa1, char aa2) {
        if (aa1 == '-' || aa2 == '-') {
            return -1;
        }
        return GprSeq.aa2Code(aa1) * AMINO_ACIDS.length + GprSeq.aa2Code(aa2);
    }

    public static String changeQuality(String qualityStr, FastqVariant fqSrc, FastqVariant fqDst) {
        int dst;
        int src;
        if (fqSrc == fqDst) {
            return qualityStr;
        }
        switch (fqSrc) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                src = 64;
                break;
            }
            case FASTQ_SANGER: {
                src = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqSrc) + "'");
            }
        }
        switch (fqDst) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                dst = 64;
                break;
            }
            case FASTQ_SANGER: {
                dst = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqDst) + "'");
            }
        }
        int diff2 = dst - src;
        if (diff2 == 0) {
            return qualityStr;
        }
        char[] oldQ = qualityStr.toCharArray();
        char[] newQ = new char[oldQ.length];
        for (int i = 0; i < oldQ.length; ++i) {
            int q = oldQ[i] - src;
            if (q < -5) {
                throw new RuntimeException("Invalid quality char '" + oldQ[i] + "' (quality = " + q + "). This doesn't look like a valid '" + (Object)((Object)fqSrc) + "' format");
            }
            newQ[i] = (char)(Math.max(0, q) + dst);
        }
        return new String(newQ);
    }

    public static char code2aa(byte aacode) {
        if (aacode < 0) {
            return '-';
        }
        return CODE_TO_AA[aacode];
    }

    public static String code2aa(byte[] aacodes) {
        char[] c = new char[aacodes.length];
        for (int i = 0; i < aacodes.length; ++i) {
            c[i] = GprSeq.code2aa(aacodes[i]);
        }
        return new String(c);
    }

    public static String code2aa(int[] aacodes) {
        char[] c = new char[aacodes.length];
        for (int i = 0; i < aacodes.length; ++i) {
            c[i] = aacodes[i] < 0 ? 45 : CODE_TO_AA[aacodes[i]];
        }
        return new String(c);
    }

    public static String code2aaPair(int code) {
        int aaCode1 = code / AMINO_ACIDS.length;
        int aaCode2 = code % AMINO_ACIDS.length;
        return "" + GprSeq.code2aa((byte)aaCode1) + GprSeq.code2aa((byte)aaCode2);
    }

    public static char code2dna(byte dnacode) {
        if (dnacode < 0) {
            return '-';
        }
        return CODE_TO_DNA[dnacode];
    }

    public static byte dna2Code(char base) {
        if (base == '-') {
            return -1;
        }
        byte c = DNA_TO_CODE[(byte)base];
        if (c < 0) {
            throw new RuntimeException("Unknown code for amino acid '" + base + "' (ord: " + base + " )");
        }
        return c;
    }

    public static String fastaSimpleRead(String fastaFile) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader inFile = Gpr.reader(fastaFile);
            if (inFile == null) {
                return "";
            }
            String line = inFile.readLine();
            while (inFile.ready()) {
                line = inFile.readLine().trim();
                sb.append(line);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String fastqId(Fastq fastq) {
        return GprSeq.readId(fastq.getDescription().substring(1));
    }

    public static boolean isAmbiguous(String sequence2) {
        char[] seq2 = sequence2.toLowerCase().toCharArray();
        for (int i = 0; i < seq2.length; ++i) {
            char c = seq2[i];
            if (c == 'a' || c == 'c' || c == 'g' || c == 't') continue;
            return true;
        }
        return false;
    }

    public static char randBase(Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    public static String randSequence(Random random, int len) {
        char[] bases = new char[len];
        for (int i = 0; i < len; ++i) {
            bases[i] = GprSeq.randBase(random);
        }
        return new String(bases);
    }

    public static String readId(String line) {
        String id = line.split("\\s")[0];
        if (id.endsWith("/1")) {
            return id.substring(0, id.length() - 2);
        }
        if (id.endsWith("/2")) {
            return id.substring(0, id.length() - 2);
        }
        return id;
    }

    public static String removeExt(String fileName) {
        return Gpr.removeExt(fileName, KNOWN_FILE_EXTENSIONS);
    }

    public static String reverse(String seq2) {
        char[] bases;
        char[] reverse2 = new char[seq2.length()];
        int i = reverse2.length - 1;
        for (char base : bases = seq2.toCharArray()) {
            reverse2[i--] = base;
        }
        return new String(reverse2);
    }

    public static String reverseWc(String seq2) {
        char[] bases;
        char[] rwc = new char[seq2.length()];
        int i = rwc.length - 1;
        for (char base : bases = seq2.toCharArray()) {
            rwc[i--] = GprSeq.wc(base);
        }
        return new String(rwc);
    }

    public static String string2fasta(String name, String sequence2) {
        StringBuffer sb = new StringBuffer();
        sb.append(">" + name + "\n");
        int lineLen = 80;
        for (int i = 0; i < sequence2.length(); i += lineLen) {
            int max2 = Math.min(i + lineLen, sequence2.length());
            sb.append(sequence2.substring(i, max2) + "\n");
        }
        return sb.toString();
    }

    public static char wc(char base) {
        switch (base) {
            case 'A': {
                return 'T';
            }
            case 'a': {
                return 't';
            }
            case 'C': {
                return 'G';
            }
            case 'c': {
                return 'g';
            }
            case 'G': {
                return 'C';
            }
            case 'g': {
                return 'c';
            }
            case 'T': 
            case 'U': {
                return 'A';
            }
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'N': {
                return 'N';
            }
            case 'n': {
                return 'n';
            }
        }
        return base;
    }

    public static String wc(String seq2) {
        char[] rwc = new char[seq2.length()];
        char[] bases = seq2.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            rwc[i] = GprSeq.wc(bases[i]);
        }
        return new String(rwc);
    }

    static {
        KNOWN_FILE_EXTENSIONS = new String[]{".fa", ".fasta", ".fq", ".fastq", ".sai", ".sam", ".bam", ".bcf", ".vcf", "pileup", "mpileup"};
        AA_TO_CODE = new byte[256];
        DNA_TO_CODE = new byte[256];
        for (int i = 0; i < AA_TO_CODE.length; ++i) {
            GprSeq.DNA_TO_CODE[i] = -1;
            GprSeq.AA_TO_CODE[i] = -1;
        }
        GprSeq.AA_TO_CODE[45] = -1;
        GprSeq.AA_TO_CODE[65] = 0;
        GprSeq.AA_TO_CODE[82] = 1;
        GprSeq.AA_TO_CODE[78] = 2;
        GprSeq.AA_TO_CODE[68] = 3;
        GprSeq.AA_TO_CODE[67] = 4;
        GprSeq.AA_TO_CODE[69] = 5;
        GprSeq.AA_TO_CODE[81] = 6;
        GprSeq.AA_TO_CODE[71] = 7;
        GprSeq.AA_TO_CODE[72] = 8;
        GprSeq.AA_TO_CODE[73] = 9;
        GprSeq.AA_TO_CODE[76] = 10;
        GprSeq.AA_TO_CODE[75] = 11;
        GprSeq.AA_TO_CODE[77] = 12;
        GprSeq.AA_TO_CODE[70] = 13;
        GprSeq.AA_TO_CODE[80] = 14;
        GprSeq.AA_TO_CODE[83] = 15;
        GprSeq.AA_TO_CODE[84] = 16;
        GprSeq.AA_TO_CODE[87] = 17;
        GprSeq.AA_TO_CODE[89] = 18;
        GprSeq.AA_TO_CODE[86] = 19;
        GprSeq.AA_TO_CODE[42] = 20;
        GprSeq.AA_TO_CODE[85] = 21;
        GprSeq.AA_TO_CODE[79] = 22;
        CODE_TO_AA = new char[23];
        GprSeq.CODE_TO_AA[0] = 65;
        GprSeq.CODE_TO_AA[1] = 82;
        GprSeq.CODE_TO_AA[2] = 78;
        GprSeq.CODE_TO_AA[3] = 68;
        GprSeq.CODE_TO_AA[4] = 67;
        GprSeq.CODE_TO_AA[5] = 69;
        GprSeq.CODE_TO_AA[6] = 81;
        GprSeq.CODE_TO_AA[7] = 71;
        GprSeq.CODE_TO_AA[8] = 72;
        GprSeq.CODE_TO_AA[9] = 73;
        GprSeq.CODE_TO_AA[10] = 76;
        GprSeq.CODE_TO_AA[11] = 75;
        GprSeq.CODE_TO_AA[12] = 77;
        GprSeq.CODE_TO_AA[13] = 70;
        GprSeq.CODE_TO_AA[14] = 80;
        GprSeq.CODE_TO_AA[15] = 83;
        GprSeq.CODE_TO_AA[16] = 84;
        GprSeq.CODE_TO_AA[17] = 87;
        GprSeq.CODE_TO_AA[18] = 89;
        GprSeq.CODE_TO_AA[19] = 86;
        GprSeq.CODE_TO_AA[20] = 42;
        GprSeq.CODE_TO_AA[21] = 85;
        GprSeq.CODE_TO_AA[22] = 79;
        GprSeq.DNA_TO_CODE[65] = 0;
        GprSeq.DNA_TO_CODE[67] = 1;
        GprSeq.DNA_TO_CODE[71] = 2;
        GprSeq.DNA_TO_CODE[84] = 3;
        CODE_TO_DNA = new char[4];
        GprSeq.CODE_TO_DNA[0] = 65;
        GprSeq.CODE_TO_DNA[1] = 67;
        GprSeq.CODE_TO_DNA[2] = 71;
        GprSeq.CODE_TO_DNA[3] = 84;
    }
}

