/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats.plot;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.stats.CoverageByType;
import ca.mcgill.mcb.pcingola.stats.plot.GoogleGeneRegionChart;
import java.util.ArrayList;

public class GoogleGeneRegionNumExonsChart
extends GoogleGeneRegionChart {
    int exons;

    public GoogleGeneRegionNumExonsChart(CoverageByType coverageByType, String name, int exons) {
        super(coverageByType, name);
        this.exons = exons;
    }

    @Override
    void initTypes() {
        ArrayList<String> typeList = new ArrayList<String>();
        boolean exonsAdded = false;
        for (String type : DEFAULT_TYPES) {
            if (type.equals(Exon.class.getSimpleName()) || type.equals(Intron.class.getSimpleName())) {
                if (exonsAdded) continue;
                for (int ex = 1; ex <= this.exons; ++ex) {
                    typeList.add(Exon.class.getSimpleName() + ":" + ex + ":" + this.exons);
                    if (ex >= this.exons) continue;
                    typeList.add(Intron.class.getSimpleName() + ":" + ex + ":" + this.exons);
                }
                exonsAdded = true;
                continue;
            }
            if (type.equals(Intergenic.class.getSimpleName())) continue;
            typeList.add(type);
        }
        this.types = typeList.toArray(new String[0]);
    }
}

