/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats.plot;

import ca.mcgill.mcb.pcingola.interval.Downstream;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Upstream;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.stats.CoverageByType;
import ca.mcgill.mcb.pcingola.stats.PosStats;
import ca.mcgill.mcb.pcingola.stats.plot.GoogleLineChart;
import java.util.ArrayList;

public class GoogleGeneRegionChart {
    protected static final String[] DEFAULT_TYPES = new String[]{Intergenic.class.getSimpleName(), Upstream.class.getSimpleName(), Utr5prime.class.getSimpleName(), Exon.class.getSimpleName(), Intron.class.getSimpleName(), Utr3prime.class.getSimpleName(), Downstream.class.getSimpleName()};
    protected String[] types;
    protected CoverageByType coverageByType;
    protected GoogleLineChart lineChart;
    protected String name;
    protected String header;
    protected String body;

    public GoogleGeneRegionChart(CoverageByType coverageByType, String name) {
        this.coverageByType = coverageByType;
        this.name = name;
        this.init();
    }

    int addCol(int nullBefore, String type) {
        ArrayList<String> values2 = this.createCol(nullBefore, type);
        this.lineChart.addColumn(type, values2);
        return values2.size();
    }

    void createChart() {
        this.initTypes();
        int nullBefore = 0;
        for (String type : this.types) {
            nullBefore = this.addCol(nullBefore, type);
        }
        this.header = this.lineChart.toStringHtmlHeader();
        this.body = this.lineChart.toStringHtmlBody();
    }

    ArrayList<String> createCol(int nullBefore, String type) {
        int i;
        ArrayList<String> col = new ArrayList<String>();
        PosStats posStats = (PosStats)this.coverageByType.get(type);
        for (i = 0; i < nullBefore; ++i) {
            col.add(null);
        }
        if (posStats != null) {
            if (posStats.size() <= 0) {
                col.add("0");
            } else {
                for (i = 0; i < posStats.size(); ++i) {
                    col.add("" + posStats.getCount(i));
                }
            }
        } else {
            col.add("0");
        }
        return col;
    }

    void init() {
        this.lineChart = new GoogleLineChart(this.name);
    }

    void initTypes() {
        this.types = DEFAULT_TYPES;
    }

    public String toStringHtmlBody() {
        if (this.body == null) {
            this.createChart();
        }
        return this.body;
    }

    public String toStringHtmlHeader() {
        if (this.header == null) {
            this.createChart();
        }
        return this.header;
    }
}

