/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;

public class VariantTypeStats
implements SamplingStats<VcfEntry> {
    public static final int MAX_MAC = 1000;
    List<String> sampleNames;
    int[] counterSnp;
    int[] counterMnp;
    int[] counterIns;
    int[] counterDel;
    int[] counterComplex;
    int[] counterMultiallelic;

    int[] getCounter(Variant.VariantType vt) {
        switch (vt) {
            case SNP: {
                return this.counterSnp;
            }
            case MNP: {
                return this.counterMnp;
            }
            case INS: {
                return this.counterIns;
            }
            case DEL: {
                return this.counterDel;
            }
            case MIXED: {
                return this.counterComplex;
            }
        }
        return null;
    }

    @Override
    public boolean hasData() {
        return this.counterSnp != null;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
            int size2 = this.sampleNames.size();
            this.counterSnp = new int[size2];
            this.counterMnp = new int[size2];
            this.counterIns = new int[size2];
            this.counterDel = new int[size2];
            this.counterComplex = new int[size2];
            this.counterMultiallelic = new int[size2];
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        byte[] gt = vcfEntry.getGenotypesScores();
        if (gt == null || gt.length < 1) {
            return;
        }
        int[] count2 = this.getCounter(vcfEntry.getVariantType());
        boolean isMultiallelic = vcfEntry.isMultiallelic();
        if (count2 != null) {
            for (int i = 0; i < gt.length; ++i) {
                if (gt[i] > 0) {
                    int n = i;
                    count2[n] = count2[n] + 1;
                }
                if (!isMultiallelic || gt[i] <= 0) continue;
                int n = i;
                this.counterMultiallelic[n] = this.counterMultiallelic[n] + 1;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            for (Variant.VariantType vt : Variant.VariantType.values()) {
                sb.append(this.toStringArray(vt.toString(), this.getCounter(vt)));
            }
            sb.append(this.toStringArray("Multiallelic", this.counterMultiallelic));
        }
        return sb.toString();
    }

    String toStringArray(String title, int[] count2) {
        if (count2 == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(title + ",");
        long total = 0L;
        for (int i = 0; i < count2.length; ++i) {
            sb.append(count2[i] + ",");
            total += (long)count2[i];
        }
        sb.append(total + "\n");
        return sb.toString();
    }
}

