/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.coverage.MarkerTypes;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.probablility.RandMarker;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashSet;

public class ReadsOnMarkersModel {
    boolean verbose;
    int readLength;
    int numIterations;
    int numReads;
    CountByType countBases;
    CountByType countMarkers;
    CountByType rawCountMarkers;
    CountByType rawCountBases;
    CountByType prob;
    SnpEffectPredictor snpEffectPredictor;
    MarkerTypes markerTypes;

    public ReadsOnMarkersModel(SnpEffectPredictor snpEffectPredictor) {
        this.snpEffectPredictor = snpEffectPredictor;
        this.countBases = new CountByType();
        this.countMarkers = new CountByType();
        this.rawCountMarkers = new CountByType();
        this.rawCountBases = new CountByType();
        this.prob = null;
        this.markerTypes = new MarkerTypes();
    }

    public void countBases() {
        Markers markers = new Markers();
        markers.add(this.snpEffectPredictor.getMarkers());
        for (Gene gene : this.snpEffectPredictor.getGenome().getGenes()) {
            markers.add(gene);
            markers.add(gene.markers());
        }
        for (Chromosome chr : this.snpEffectPredictor.getGenome()) {
            markers.add(chr);
        }
        for (Marker m : markers) {
            String mtype = this.markerTypes.getType(m);
            String msubtype = this.markerTypes.getSubType(m);
            this.rawCountMarkers.inc(mtype);
            this.rawCountBases.inc(mtype, m.size());
            if (msubtype == null) continue;
            this.rawCountMarkers.inc(msubtype);
            this.rawCountBases.inc(msubtype, m.size());
        }
        for (String mtype : this.rawCountMarkers.keysSorted()) {
            if (mtype.equals(Chromosome.class.getSimpleName())) continue;
            if (this.verbose) {
                System.err.print(mtype + ":");
            }
            if (this.countMarkers.get(mtype) == 0L) {
                for (Chromosome chr : this.snpEffectPredictor.getGenome()) {
                    this.countBases(mtype, chr, markers);
                }
            }
            if (!this.verbose) continue;
            System.err.println("");
        }
        String mtype = Chromosome.class.getSimpleName();
        for (Chromosome chr : this.snpEffectPredictor.getGenome()) {
            this.countBases.inc(mtype, chr.size());
            this.countMarkers.inc(mtype);
        }
    }

    void countBases(String mtype, Chromosome chr, Markers markers) {
        String chrName = chr.getChromosomeName();
        if (this.verbose) {
            System.err.print(" " + chrName);
        }
        byte[] busy = new byte[chr.size()];
        for (int i = 0; i < busy.length; ++i) {
            busy[i] = 0;
        }
        for (Marker m : markers) {
            if (!m.getChromosomeName().equals(chrName) || !this.markerTypes.isType(m, mtype)) continue;
            for (int i = m.getStart(); i <= m.getEnd(); ++i) {
                busy[i] = 1;
            }
        }
        int latest = 0;
        for (int i = 0; i < busy.length; ++i) {
            if (i > 0 && busy[i] != 0 && busy[i - 1] == 0) {
                if (i - latest <= this.readLength) {
                    this.countBases.inc(mtype, i - latest);
                } else {
                    this.countMarkers.inc(mtype);
                }
            }
            if (busy[i] == 0) continue;
            this.countBases.inc(mtype);
            latest = i;
        }
    }

    public CountByType getCountBases() {
        return this.countBases;
    }

    public CountByType getCountMarkers() {
        return this.countMarkers;
    }

    public CountByType getProb() {
        return this.prob;
    }

    public CountByType getRawCountBases() {
        return this.rawCountBases;
    }

    public CountByType getRawCountMarkers() {
        return this.rawCountMarkers;
    }

    public void load(String fileName) {
        boolean header = true;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            if (header) {
                header = false;
                continue;
            }
            String[] recs = line.split("\t");
            String mtype = recs[0];
            this.countBases.inc(mtype, Gpr.parseIntSafe(recs[1]));
            this.countMarkers.inc(mtype, Gpr.parseIntSafe(recs[2]));
        }
    }

    void probabilities() {
        if (this.prob != null) {
            return;
        }
        String chrType = Chromosome.class.getSimpleName();
        long chrSize = this.countBases.get(chrType);
        long chrCount = this.countMarkers.get(chrType);
        if (chrCount <= 0L) {
            return;
        }
        int readLength = this.readLength;
        if (readLength < 1) {
            readLength = 1;
        }
        this.prob = new CountByType();
        for (String mtype : this.countMarkers.keysSorted()) {
            long size2 = this.countBases.get(mtype);
            long count2 = this.countMarkers.get(mtype);
            double p = (double)(size2 + (long)(readLength - 1) * count2) / (double)(chrSize - (long)(readLength - 1) * chrCount);
            p = Math.min(1.0, p);
            p = Math.max(0.0, p);
            this.prob.setScore(mtype, p);
        }
    }

    CountByType randomSampling(int readLen, int numReads) {
        CountByType countReads = new CountByType();
        RandMarker randMarker = new RandMarker(this.snpEffectPredictor.getGenome());
        for (int i = 0; i < numReads; ++i) {
            Marker read2 = randMarker.rand(readLen);
            Markers regions = this.snpEffectPredictor.queryDeep(read2);
            HashSet<String> doneRegion = new HashSet<String>();
            for (Marker m : regions) {
                String mtype = this.markerTypes.getType(m);
                String msubtype = this.markerTypes.getSubType(m);
                if (!doneRegion.contains(mtype)) {
                    countReads.inc(mtype);
                    doneRegion.add(mtype);
                }
                if (msubtype == null || doneRegion.contains(msubtype)) continue;
                countReads.inc(msubtype);
                doneRegion.add(msubtype);
            }
        }
        return countReads;
    }

    public void randomSampling(int iterations, int readLen, int numReads) {
        System.out.print("Iteration");
        for (String type : this.rawCountMarkers.keysSorted()) {
            System.out.print("\t" + type);
        }
        System.out.println("");
        for (int it = 0; it < iterations; ++it) {
            CountByType count2 = this.randomSampling(readLen, numReads);
            System.out.print(it);
            for (String type : this.rawCountMarkers.keysSorted()) {
                System.out.print("\t" + count2.get(type));
            }
            System.out.println("");
        }
    }

    public boolean run() {
        this.countBases();
        this.probabilities();
        return true;
    }

    public void save(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append("marker_type\tsize\tcount\tbinomial_p\n");
        this.probabilities();
        for (String mtype : this.markerTypes.markerTypesClass()) {
            sb.append(mtype + "\t" + this.countBases.get(mtype) + "\t" + this.countMarkers.get(mtype) + "\n");
        }
        Gpr.toFile(fileName, sb.toString());
    }

    public void setMarkerTypes(MarkerTypes markerTypes) {
        this.markerTypes = markerTypes;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setNumReads(int numReads) {
        this.numReads = numReads;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }

    public void setSnpEffectPredictor(SnpEffectPredictor snpEffectPredictor) {
        this.snpEffectPredictor = snpEffectPredictor;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("marker_type\tsize\tcount\traw_size\traw_count\tbinomial_p\n");
        this.probabilities();
        for (String mtype : this.countMarkers.keysSorted()) {
            sb.append(mtype + "\t" + this.countBases.get(mtype) + "\t" + this.countMarkers.get(mtype) + "\t" + this.rawCountBases.get(mtype) + "\t" + this.rawCountMarkers.get(mtype) + "\t" + this.prob.getScore(mtype) + "\n");
        }
        return sb.toString();
    }
}

