/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public abstract class ObservedOverExpected {
    public double expected(Exon e) {
        String seq2 = e.getSequence();
        double eplus = this.expected(seq2);
        double eminus = this.expected(GprSeq.reverseWc(seq2));
        return (eplus + eminus) / 2.0;
    }

    public double expected(Gene g) {
        double eplus = 0.0;
        double eminus = 0.0;
        for (Transcript t2 : g) {
            for (Exon e : t2) {
                String seq2 = e.getSequence();
                eplus += this.expected(seq2);
                eminus += this.expected(GprSeq.reverseWc(seq2));
            }
        }
        return (eplus + eminus) / 2.0;
    }

    public abstract double expected(String var1);

    public double expected(Transcript t2) {
        double eplus = 0.0;
        double eminus = 0.0;
        for (Exon e : t2) {
            String seq2 = e.getSequence();
            eplus += this.expected(seq2);
            eminus += this.expected(GprSeq.reverseWc(seq2));
        }
        return (eplus + eminus) / 2.0;
    }

    public int observed(Exon e) {
        String seq2 = e.getSequence();
        int oplus = this.observed(seq2);
        int ominus = this.observed(GprSeq.reverseWc(seq2));
        return (oplus + ominus) / 2;
    }

    public int observed(Gene g) {
        int oplus = 0;
        int ominus = 0;
        for (Transcript t2 : g) {
            for (Exon e : t2) {
                String seq2 = e.getSequence();
                oplus += this.observed(seq2);
                ominus += this.observed(GprSeq.reverseWc(seq2));
            }
        }
        return (oplus + ominus) / 2;
    }

    public abstract int observed(String var1);

    public int observed(Transcript t2) {
        int oplus = 0;
        int ominus = 0;
        for (Exon e : t2) {
            String seq2 = e.getSequence();
            oplus += this.observed(seq2);
            ominus += this.observed(GprSeq.reverseWc(seq2));
        }
        return (oplus + ominus) / 2;
    }

    public int observedChg(String sequence2) {
        int count2 = 0;
        char[] bases = sequence2.toUpperCase().toCharArray();
        for (int i = 0; i < bases.length - 2; ++i) {
            if (bases[i] != 'C' || bases[i + 1] == 'G' || bases[i + 2] != 'G') continue;
            ++count2;
        }
        return count2;
    }

    public double oe(Exon e) {
        return (double)this.observed(e) / this.expected(e);
    }

    public double oe(Gene g) {
        double exp = this.expected(g);
        return exp > 0.0 ? (double)this.observed(g) / exp : 0.0;
    }

    public double oe(String sequence2) {
        double exp = this.expected(sequence2);
        return exp > 0.0 ? (double)this.observed(sequence2) / exp : 0.0;
    }

    public double oe(Transcript t2) {
        double exp = this.expected(t2);
        return exp > 0.0 ? (double)this.observed(t2) / exp : 0.0;
    }
}

