/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;

public class AlleleCountStats
implements SamplingStats<VcfEntry> {
    public static final int MAX_MAC = 1000;
    List<String> sampleNames;
    int[][] counters;

    @Override
    public boolean hasData() {
        return this.counters != null;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
            int size2 = this.sampleNames.size();
            int sizeMac = Math.min(1000, size2);
            this.counters = new int[sizeMac][size2];
            for (int i = 0; i < this.counters.length; ++i) {
                for (int j = 0; j < size2; ++j) {
                    this.counters[i][j] = 0;
                }
            }
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        byte[] gt = vcfEntry.getGenotypesScores();
        if (gt == null || gt.length < 1) {
            return;
        }
        int mac = vcfEntry.mac();
        if (mac >= 0 && mac < this.counters.length) {
            int[] count2 = this.counters[mac];
            for (int i = 0; i < gt.length; ++i) {
                if (gt[i] <= 0) continue;
                int n = i;
                count2[n] = count2[n] + 1;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            for (int i = 0; i < this.counters.length; ++i) {
                sb.append(this.toStringArray("MAC=" + i, this.counters[i]));
            }
        }
        return sb.toString();
    }

    String toStringArray(String title, int[] count2) {
        StringBuilder sb = new StringBuilder();
        sb.append(title + ",");
        long total = 0L;
        for (int i = 0; i < count2.length; ++i) {
            sb.append(count2[i] + ",");
            total += (long)count2[i];
        }
        sb.append(total + "\n");
        return sb.toString();
    }
}

