/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.spliceSites;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TranscriptSet
implements Iterable<Transcript> {
    public static final int MAX_TRANSCRIPTS_PER_GENE = 1000;
    HashSet<Transcript> transcripts = new HashSet();
    AutoHashMap<String, ArrayList<Transcript>> transcriptsByChromo = new AutoHashMap(new ArrayList());

    public TranscriptSet(Genome genome) {
        for (Gene gene : genome.getGenes()) {
            if (gene.numChilds() > 1000) {
                System.err.println("Ignoring gene '" + gene.getGeneName() + "', too many transcripts (" + gene.numChilds() + ")");
                continue;
            }
            for (Transcript tr : gene) {
                if (!tr.isProteinCoding() || tr.hasError()) continue;
                this.transcripts.add(tr);
                this.transcriptsByChromo.getOrCreate(tr.getChromosomeName()).add(tr);
            }
        }
    }

    public List<Transcript> getByChromo(String chrName) {
        return this.transcriptsByChromo.getOrCreate(Chromosome.simpleName(chrName));
    }

    @Override
    public Iterator<Transcript> iterator() {
        return this.transcripts.iterator();
    }
}

