/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.fileIterator.SeekableBufferedReader;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesSeekableReader {
    long calcHash(String fileName) throws IOException {
        String line;
        SeekableBufferedReader sbr = new SeekableBufferedReader(fileName);
        long hash2 = 0L;
        while ((line = sbr.readLine()) != null) {
            hash2 += (long)line.hashCode();
        }
        sbr.close();
        return hash2;
    }

    long calcHashBufferedReader(String fileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
        long hash2 = 0L;
        while ((line = br.readLine()) != null) {
            hash2 += (long)line.hashCode();
        }
        br.close();
        return hash2;
    }

    @Test
    public void test_00() throws IOException {
        Gpr.debug("Test");
        String fileName = "tests/testLukas.vcf";
        long hashExp = this.calcHashBufferedReader(fileName);
        long hash2 = this.calcHash(fileName);
        System.out.println(String.format("%016x\t%016x\t%s", hashExp, hash2, fileName));
        Assert.assertEquals(hashExp, hash2);
    }

    @Test
    public void test_01() throws IOException {
        Gpr.debug("Test");
        String dirName = "./tests/";
        File dir = new File(dirName);
        for (String fileName : dir.list()) {
            if (!fileName.endsWith(".txt") && !fileName.endsWith(".vcf") || !fileName.equals("testLukas.vcf")) continue;
            fileName = dirName + fileName;
            long hashExp = this.calcHashBufferedReader(fileName);
            long hash2 = this.calcHash(fileName);
            System.out.println(String.format("%016x\t%016x\t%s", hashExp, hash2, fileName));
            Assert.assertEquals(hashExp, hash2);
        }
    }
}

