/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Random;
import org.junit.Test;

public class TestCasesMarkerSeq {
    protected boolean debug;
    protected boolean verbose;
    protected int randSeed;
    protected Random rand;

    public TestCasesMarkerSeq() {
        this.verbose = this.debug = false;
        this.randSeed = 20141128;
    }

    protected void initRand() {
        this.rand = new Random(this.randSeed);
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        this.initRand();
        int maxSize = 20;
        String genome = "testHg19Chr17";
        String vcf = "tests/hgvs_dup.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setUpDownStreamLength(0);
        snpeff.load();
        Config config = snpeff.getConfig();
        int count2 = 0;
        for (Gene g : config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    Gpr.showMark(count2++, 100);
                    String sequence2 = ex.getSequence();
                    if (ex.isStrandMinus()) {
                        sequence2 = GprSeq.reverseWc(sequence2);
                    }
                    if (this.verbose) {
                        Gpr.debug("Transcript: " + tr.getId() + "\tExon: " + ex.getId() + ", strand: " + (ex.isStrandPlus() ? "+" : "-") + "\tSequence: " + sequence2);
                    }
                    int i = 0;
                    for (int pos = ex.getStart(); pos <= ex.getEnd(); ++pos) {
                        int size2 = this.rand.nextInt(maxSize);
                        if (size2 > ex.getEnd() - pos) {
                            size2 = 0;
                        }
                        String seqExpected = sequence2.substring(i, i + size2 + 1);
                        Marker m = new Marker(ex.getChromosome(), pos, pos + size2, false, "");
                        String seq2 = ex.getSequence(m);
                        if (!seq2.equalsIgnoreCase(seqExpected)) {
                            String msg = "Expecting '" + seqExpected + "', got '" + seq2 + "'";
                            System.err.println("ERROR:\t" + msg);
                            throw new RuntimeException(msg);
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

