/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerUtil;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesIntervals {
    int maxLen = 100;
    boolean verbose = false;
    boolean compareCdsTestsEnable = false;
    Random rand;
    Genome genome;

    public TestCasesIntervals() {
        this.initRand();
        String genomeName = "testCaseHg";
        this.genome = new Genome(genomeName);
        for (int i = 1; i < 22; ++i) {
            this.genome.add(new Chromosome(this.genome, 0, 0, "" + i));
        }
        this.genome.add(new Chromosome(this.genome, 0, 0, "X"));
        this.genome.add(new Chromosome(this.genome, 0, 0, "Y"));
    }

    boolean anyResultMatches(String transcriptId, Variant variant, List<VariantEffect> resultsList, boolean useSimple, StringBuilder resultsSoFar) {
        boolean ok = false;
        for (VariantEffect chEff : resultsList) {
            String resStr = chEff.toStringSimple(!useSimple);
            if (this.verbose) {
                System.out.println(variant + "\t'" + resStr + "'");
            }
            String effTrId = chEff.getMarker().findParent(Transcript.class).getId();
            if (transcriptId != null && !transcriptId.equals(effTrId)) continue;
            if (!variant.getId().equals(resStr)) {
                if (this.verbose) {
                    Gpr.debug("SeqChange: " + variant + "\tResult: '" + chEff + "'");
                }
                resultsSoFar.append(variant + "\t'" + resStr + "'\n");
                continue;
            }
            ok = true;
            break;
        }
        return ok;
    }

    public void compareToFile(String result2, String fileName) {
        String file = Gpr.readFile(fileName).trim();
        if (!(result2 = result2.trim()).equals(file)) {
            String errMsg = "Results and file '" + fileName + "' do not match:\n--- Results ---\n" + result2 + "\n--- File '" + fileName + "' ---\n" + file + "\n--- End ---\n";
            System.err.println(errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    public void DnaSequenceBaseAt(int len) {
        char[] bases = new char[len];
        for (int i = 0; i < bases.length; ++i) {
            char base;
            bases[i] = base = GprSeq.BASES[(int)(Math.random() * 4.0)];
        }
        String sequence2 = new String(bases);
        DnaSequence DnaSequence2 = new DnaSequence(sequence2);
        if (this.verbose) {
            System.out.println("DnaSequence (len:" + len + ") : " + DnaSequence2);
        }
        for (int i = 0; i < bases.length; ++i) {
            char base = Character.toUpperCase(DnaSequence2.getBase(i));
            if (base == bases[i]) continue;
            throw new RuntimeException("Bases do not match! Base:" + base + "\tOriginal sequence: " + bases[i]);
        }
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    public Markers intersects(Markers interval1, Marker intervals) {
        Markers ints = new Markers();
        for (Marker i : interval1) {
            if (!i.intersects(intervals)) continue;
            ints.add(i);
        }
        return ints;
    }

    public Markers randomIntervals(int numIntervals, int maxStart, int maxLength, int numChromo) {
        Markers ints = new Markers();
        for (int ch = 1; ch <= numChromo; ++ch) {
            for (int i = 0; i < numIntervals; ++i) {
                int start = this.rand.nextInt(maxStart);
                int end = Math.min(start + this.rand.nextInt(maxLength), maxStart - 1);
                Marker interval = new Marker(this.genome.getChromosome("" + ch), start, end, false, "");
                ints.add(interval);
            }
        }
        return ints;
    }

    @Test
    public void test_00() {
        Gpr.debug("Test");
        this.initRand();
        for (int len = 1; len < 1000; ++len) {
            this.DnaSequenceBaseAt(len);
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        this.initRand();
        Markers intervals = MarkerUtil.readTxt("tests/interval_data_100.txt", this.genome, 0);
        this.compareToFile(intervals.toStringTxt(), "tests/test_01.txt");
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        this.initRand();
        Markers intervals = this.randomIntervals(10, this.maxLen, 10, 5);
        intervals.sort(false, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_02.txt");
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        this.initRand();
        Markers intervals = this.randomIntervals(100, this.maxLen, 25, 2);
        intervals.sort(true, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_03.txt");
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        this.initRand();
        Markers intervals = this.randomIntervals(20, this.maxLen, 10, 2);
        Markers merge = intervals.merge();
        if (this.verbose) {
            System.out.println("Merge :\n" + merge.toStringAsciiArt(this.maxLen));
        }
        this.compareToFile(merge.toStringTxt(), "tests/test_04.txt");
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        this.initRand();
        Markers intervals = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers intervals2 = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers add2 = new Markers();
        add2.add(intervals);
        add2.add(intervals2);
        this.compareToFile(add2.toStringTxt(), "tests/test_05.txt");
        if (this.verbose) {
            intervals.sort(false, false);
            intervals2.sort(false, false);
            add2.sort(false, false);
            System.out.println("Intervals 1:\n" + intervals.toStringAsciiArt(this.maxLen));
            System.out.println("Intervals 2:\n" + intervals2.toStringAsciiArt(this.maxLen));
            System.out.println("Union :\n" + add2.toStringAsciiArt(this.maxLen));
        }
    }

    @Test
    public void test_06() {
        Gpr.debug("Test");
        for (int numInts = 10; numInts < 1000; numInts *= 2) {
            Markers intervals = this.randomIntervals(numInts, this.maxLen, 20, 2);
            IntervalForest forest = new IntervalForest(intervals);
            if (this.verbose) {
                intervals.sort(false, false);
                System.out.println(intervals.toStringAsciiArt(this.maxLen));
                forest.build();
                System.out.println(forest);
            }
            Markers intervals2 = this.randomIntervals(numInts, this.maxLen, 20, 2);
            for (Marker i : intervals2) {
                Markers intersectBf;
                Markers intersect2 = forest.query(i);
                if (intersect2.equals(intersectBf = this.intersects(intervals, i))) continue;
                intersect2.sort(false, false);
                intersectBf.sort(false, false);
                String errMsg = "Interval: " + i + "\n\tIntersects  : " + intersect2 + "\n\tIntersectsBf: " + intersectBf;
                System.err.println(errMsg);
                throw new RuntimeException(errMsg);
            }
        }
    }

    @Test
    public void test_07_01() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, false, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 10, 90, false, ""));
        Markers minus2 = intervals.minus(intervals2);
        Assert.assertEquals(0, minus2.size());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    @Test
    public void test_07_02() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, false, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 91, false, ""));
        Markers minus2 = intervals.minus(intervals2);
        Assert.assertEquals(0, minus2.size());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    @Test
    public void test_07_03() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, false, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 50, false, ""));
        Markers minus2 = intervals.minus(intervals2);
        Assert.assertEquals(1, minus2.size());
        Marker minusInt = minus2.iterator().next();
        Assert.assertEquals(51, minusInt.getStart());
        Assert.assertEquals(90, minusInt.getEnd());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    @Test
    public void test_07_04() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, false, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 51, 91, false, ""));
        Markers minus2 = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
        Assert.assertEquals(1, minus2.size());
        Marker minusInt = minus2.iterator().next();
        Assert.assertEquals(10, minusInt.getStart());
        Assert.assertEquals(50, minusInt.getEnd());
    }

    @Test
    public void test_07_05() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, false, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 40, 60, false, ""));
        Markers minus2 = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
        Assert.assertEquals(2, minus2.size());
        Iterator<Marker> it = minus2.iterator();
        Marker minusInt = it.next();
        Assert.assertEquals(10, minusInt.getStart());
        Assert.assertEquals(39, minusInt.getEnd());
        minusInt = it.next();
        Assert.assertEquals(61, minusInt.getStart());
        Assert.assertEquals(90, minusInt.getEnd());
    }

    @Test
    public void test_08() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Marker m1 = new Marker(chr, 0, 100, false, "");
        ArrayList<Marker> list2 = new ArrayList<Marker>();
        list2.add(m1);
        int last2 = m1.getEnd() + 10;
        for (int i = m1.getStart(); i <= last2; ++i) {
            Marker m = new Marker(chr, i, i, false, "");
            int dist = m.distanceBases(list2, false);
            Assert.assertEquals(i, dist);
        }
    }

    @Test
    public void test_08_02() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Marker m1 = new Marker(chr, 0, 99, false, "");
        Marker m2 = new Marker(chr, 200, 299, false, "");
        Marker m3 = new Marker(chr, 400, 499, false, "");
        ArrayList<Marker> list2 = new ArrayList<Marker>();
        list2.add(m1);
        list2.add(m2);
        list2.add(m3);
        int last2 = m3.getEnd() + 10;
        for (int i = m1.getStart(); i <= last2; ++i) {
            Marker m = new Marker(chr, i, i, false, "");
            int dist = m.distanceBases(list2, false);
            Assert.assertEquals(i % 100, dist % 100);
        }
    }

    @Test
    public void test_08_03() {
        Gpr.debug("Test");
        Chromosome chr = this.genome.getChromosome("1");
        Marker m1 = new Marker(chr, 0, 99, false, "");
        Marker m2 = new Marker(chr, 200, 299, false, "");
        Marker m3 = new Marker(chr, 400, 499, false, "");
        ArrayList<Marker> list2 = new ArrayList<Marker>();
        list2.add(m1);
        list2.add(m2);
        list2.add(m3);
        int last2 = m3.getEnd() + 10;
        for (int i = m1.getStart(); i <= last2; ++i) {
            Marker m = new Marker(chr, i, i, false, "");
            int dist = m.distanceBases(list2, true);
            Assert.assertEquals((m3.getEnd() - i) % 100, dist % 100);
        }
    }

    @Test
    public void test_09_chrOrder() {
        Gpr.debug("Test");
        Genome genome = new Genome("test");
        Chromosome chrA = new Chromosome(genome, 0, 1, "6");
        Chromosome chrB = new Chromosome(genome, 0, 1, "10");
        Chromosome chrC = new Chromosome(genome, 0, 1, "4_ctg9_hap1");
        Assert.assertTrue(chrA.compareTo(chrB) < 0);
        Assert.assertTrue(chrA.compareTo(chrC) < 0);
        Assert.assertTrue(chrB.compareTo(chrC) < 0);
    }

    @Test
    public void test_10_chrOrder() {
        Gpr.debug("Test");
        Genome genome = new Genome("test");
        Chromosome chrA = new Chromosome(genome, 0, 1, "chr1");
        Chromosome chrB = new Chromosome(genome, 0, 1, "scaffold0001");
        Assert.assertTrue(chrA.compareTo(chrB) < 0);
    }
}

