/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesEffectCollapse
extends TestCasesBase {
    void check(int pos, String effStrExpected) {
        if (this.verbose) {
            Gpr.debug("Transcript:" + this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, pos, "A", "T");
        VariantEffects veffs = this.snpEffectPredictor.variantEffect(variant);
        if (this.verbose) {
            System.err.println("Variant: " + variant);
            System.err.println("Effects: " + veffs.size());
            for (VariantEffect veff : veffs) {
                System.err.println("\tEff: '" + veff.effect(false, false, false, false, false) + "'");
            }
        }
        Assert.assertEquals(1, veffs.size());
        String effStr = veffs.get(0).effect(false, false, false, false, false);
        Assert.assertEquals(effStrExpected, effStr);
    }

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20141205;
        this.minExons = 2;
        this.spliceRegionExonSize = 3;
        this.spliceRegionIntronMin = 3;
        this.spliceRegionIntronMax = 8;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        this.check(809, "NON_SYNONYMOUS_CODING+SPLICE_SITE_REGION");
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        this.check(811, "SPLICE_SITE_DONOR+INTRON");
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        this.check(1010, "SPLICE_SITE_REGION+INTRON");
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        this.check(1012, "SPLICE_SITE_ACCEPTOR+INTRON");
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        this.check(1013, "NON_SYNONYMOUS_CODING+SPLICE_SITE_REGION");
    }
}

