/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.binseq.BinarySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaAndQualitySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.binseq.comparator.DnaQualSubsequenceComparator;
import ca.mcgill.mcb.pcingola.binseq.comparator.DnaSubsequenceComparator;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesDnaOverlap {
    public static boolean verbose = false;

    String change(String sequence2, int numChanges, Random rand) {
        HashSet<Integer> changedPos = new HashSet<Integer>();
        char[] chars = sequence2.toCharArray();
        int i = 0;
        while (i < numChanges) {
            int pos = rand.nextInt(chars.length);
            if (changedPos.contains(pos)) continue;
            int newCode = rand.nextInt() & 3;
            char newBase = DnaCoder.get().toBase(newCode);
            if (chars[pos] == newBase) continue;
            chars[pos] = newBase;
            changedPos.add(pos);
            ++i;
        }
        return new String(chars);
    }

    void dnaCoderCopyBases(int seqLenSrc, int seqLenDst, Random rand) {
        String srcStr = this.randSeq(seqLenSrc, rand);
        String dstStr = this.randSeq(seqLenDst, rand);
        DnaSequence src = new DnaSequence(srcStr);
        DnaSequence dst = null;
        dst = new DnaSequence(dstStr);
        long signature = src.getCodes()[0];
        int srcStart = rand.nextInt(src.length());
        int dstStart = rand.nextInt(dst.length());
        int len = rand.nextInt(Math.min(src.length() - srcStart, dst.length() - dstStart)) + 1;
        String subStr = srcStr.substring(srcStart, srcStart + len);
        String dstBefore = dst.getSequence().substring(0, dstStart);
        String dstAfter = dst.getSequence().substring(dstStart + len);
        DnaCoder.get().copyBases(src.getCodes(), srcStart, dst.getCodes(), dstStart, len);
        String subStrDst = dst.getSequence().substring(dstStart, dstStart + len);
        String dstBefore2 = dst.getSequence().substring(0, dstStart);
        String dstAfter2 = dst.getSequence().substring(dstStart + len);
        if (!subStr.equals(subStrDst)) {
            throw new RuntimeException("Substrings do not match! signature=" + Long.toHexString(signature) + " \n\t" + subStr + "\n\t" + subStrDst);
        }
        if (!dstBefore2.equals(dstBefore)) {
            throw new RuntimeException("Substrings 'before' do not match! signature=" + Long.toHexString(signature) + "\n\tdstBefore:\t" + dstBefore + "\n\tdstBefore2:\t" + dstBefore2);
        }
        if (!dstAfter2.equals(dstAfter)) {
            throw new RuntimeException("Substrings 'after' do not match! signature=" + Long.toHexString(signature) + "\n\tdstAfter:\t" + dstAfter + "\n\tdstAfter2:\t" + dstAfter2);
        }
    }

    void overlap(String seq1, String seq2, int start, String result2, String resultQ) {
        this.overlapDnaSequence(seq1, seq2, start, result2);
        this.overlapDnaAndQualitySequence(seq1, seq2, start, result2, resultQ);
    }

    void overlapDnaAndQualitySequence(String seq1, String seq2, int start, String result2, String resultQ) {
        DnaAndQualitySequence s1 = new DnaAndQualitySequence(seq1, this.q(seq1.length(), 2), FastqVariant.FASTQ_SANGER);
        DnaAndQualitySequence s2 = new DnaAndQualitySequence(seq2, this.q(seq2.length(), 3), FastqVariant.FASTQ_SANGER);
        DnaAndQualitySequence s3 = s1.overlap(s2, start);
        Assert.assertEquals(result2, s3.getSequence());
        if (resultQ != null) {
            Assert.assertEquals(resultQ, s3.getQuality());
        }
    }

    void overlapDnaSequence(String seq1, String seq2, int start, String result2) {
        DnaSequence s1 = new DnaSequence(seq1);
        DnaSequence s2 = new DnaSequence(seq2);
        BinarySequence s3 = s1.overlap(s2, start);
        Assert.assertEquals(result2, s3.getSequence());
    }

    void overlapRandTest(int maxLen, int minLen, Random rand) {
        int over;
        int len1 = rand.nextInt(maxLen) + minLen;
        String seq1 = this.randSeq(len1, rand);
        int start = over = rand.nextInt(len1 - minLen + 1);
        String overlap = "";
        String nonOverlap = "";
        String seq2 = "";
        String result2 = "";
        int len2 = rand.nextInt(maxLen - over);
        if (rand.nextBoolean()) {
            overlap = seq1.substring(over);
            nonOverlap = this.randSeq(len2, rand);
            seq2 = overlap + nonOverlap;
            result2 = seq1 + nonOverlap;
        } else {
            overlap = seq1.substring(0, over);
            nonOverlap = this.randSeq(len2, rand);
            seq2 = nonOverlap + overlap;
            start = -nonOverlap.length();
            result2 = nonOverlap + seq1;
        }
        this.overlap(seq1, seq2, start, result2, null);
    }

    String q(int len, int quality) {
        char[] q = new char[len];
        for (int i = 0; i < len; ++i) {
            q[i] = (char)(33 + quality);
        }
        return new String(q);
    }

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
        }
        return sb.toString();
    }

    void score(String seq1, String seq2, int start, int threshold, int result2) {
        this.scoreDnaSequence(seq1, seq2, start, threshold, result2);
        this.scoreDnaAndQualitySequence(seq1, seq2, start, threshold, result2);
    }

    void scoreDnaAndQualitySequence(String seq1, String seq2, int start, int threshold, int result2) {
        DnaAndQualitySequence s1 = new DnaAndQualitySequence(seq1);
        DnaAndQualitySequence s2 = new DnaAndQualitySequence(seq2);
        DnaQualSubsequenceComparator compartor = new DnaQualSubsequenceComparator(true, threshold);
        int idx1 = start >= 0 ? start : 0;
        int idx2 = start >= 0 ? 0 : -start;
        int score = compartor.score(s1, idx1, s2, idx2);
        Assert.assertEquals(result2, score);
    }

    void scoreDnaSequence(String seq1, String seq2, int start, int threshold, int result2) {
        DnaSequence s1 = new DnaSequence(seq1);
        DnaSequence s2 = new DnaSequence(seq2);
        DnaSubsequenceComparator compartor = new DnaSubsequenceComparator(true, threshold);
        int idx1 = start >= 0 ? start : 0;
        int idx2 = start >= 0 ? 0 : -start;
        int score = compartor.score(s1, idx1, s2, idx2);
        Assert.assertEquals(result2, score);
    }

    void scoreRandTest(int maxLen, int minLen, Random rand, DnaCoder dnaCoder, DnaSubsequenceComparator<DnaSequence> comparator) {
        int over;
        int len1 = rand.nextInt(maxLen) + minLen;
        String seq1 = this.randSeq(len1, rand);
        int start = over = rand.nextInt(len1 - minLen + 1);
        String overlap = "";
        String nonOverlap = "";
        String seq2 = "";
        int len2 = rand.nextInt(maxLen - over);
        if (rand.nextBoolean()) {
            overlap = seq1.substring(over);
            nonOverlap = this.randSeq(len2, rand);
            seq2 = overlap + nonOverlap;
        } else {
            overlap = seq1.substring(0, over);
            nonOverlap = this.randSeq(len2, rand);
            seq2 = nonOverlap + overlap;
            start = -nonOverlap.length();
        }
        DnaSequence s1 = new DnaSequence(seq1);
        DnaSequence s2 = new DnaSequence(seq2);
        int threshold = 0;
        boolean found = over <= 0;
        for (int i = 0; i < 10 || !found; ++i) {
            int starti;
            int score1 = 0;
            int score2 = 0;
            int len = 0;
            if (start > 0) {
                starti = rand.nextInt(s1.length());
                len = Math.min(seq2.length(), seq1.length() - starti);
                score1 = dnaCoder.score(s2.getCodes(), s1.getCodes(), starti, len, threshold);
                score2 = comparator.scoreSlow(s2, 0, s1, starti);
            } else {
                starti = rand.nextInt(s2.length());
                len = Math.min(seq1.length(), seq2.length() - starti);
                score1 = dnaCoder.score(s1.getCodes(), s2.getCodes(), starti, len, threshold);
                score2 = comparator.scoreSlow(s1, 0, s2, starti);
            }
            if (score1 != score2) {
                throw new RuntimeException("Scores do not match!\n\tscore1: " + score1 + "\n\tscore2: " + score2 + "\n\tstarti: " + starti + "\n\tstart: " + start + "\n\tlen: " + len);
            }
            if (score1 <= 0) continue;
            found = true;
        }
    }

    void scoreRandTestThreshold(int maxLen, int minLen, Random rand, int threshold, int overlapChanges) {
        int over;
        int len1 = rand.nextInt(maxLen) + minLen;
        String seq1 = this.randSeq(len1, rand);
        if (verbose) {
            System.out.println("\nseq1:\t" + seq1);
        }
        int start = over = rand.nextInt(len1 - minLen + 1);
        String overlap = "";
        String nonOverlap = "";
        String seq2 = "";
        int expectedScore = 0;
        int len2 = rand.nextInt(maxLen - over);
        if (rand.nextBoolean()) {
            overlap = seq1.substring(over);
            overlapChanges = Math.min(overlapChanges, overlap.length());
            overlap = this.change(overlap, overlapChanges, rand);
            if (verbose) {
                System.out.println("over:\t" + overlap);
            }
            nonOverlap = this.randSeq(len2, rand);
            seq2 = overlap + nonOverlap;
        } else {
            overlap = seq1.substring(0, over);
            overlapChanges = Math.min(overlapChanges, overlap.length());
            overlap = this.change(overlap, overlapChanges, rand);
            if (verbose) {
                System.out.println("over:\t" + overlap);
            }
            nonOverlap = this.randSeq(len2, rand);
            seq2 = nonOverlap + overlap;
            start = -nonOverlap.length();
        }
        if (verbose) {
            System.out.println("seq2:\t" + seq2);
        }
        int n = expectedScore = overlapChanges <= threshold ? overlap.length() - overlapChanges : 0;
        if (verbose) {
            System.out.println("start:\t" + start + "\tthreshold: " + threshold + "\toverlapChanges: " + overlapChanges + "\tscore: " + expectedScore);
        }
        this.score(seq1, seq2, start, threshold, expectedScore);
    }

    @Test
    public void test_07_overlap() {
        Gpr.debug("Test");
        this.overlap("catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", -47, "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#################################################################");
    }

    @Test
    public void test_08_overlap() {
        Gpr.debug("Test");
        this.overlap("tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", "catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", 47, "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "###############################################&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
    }

    @Test
    public void test_09_overlap() {
        Gpr.debug("Test");
        this.overlap("tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", "catagaaaccaacagccatataactggtagctttaagcggctc", 47, "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", "###############################################&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
    }

    @Test
    public void test_10_overlap() {
        Gpr.debug("Test");
        this.overlap("catagaaaccaacagccatataactggtagctttaagcggctc", "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", -47, "tttagcagcaaggtccatatctgactttttgttaacgtatttagccacatagaaaccaacagccatataactggtagctttaagcggctc", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
    }

    @Test
    public void test_11_overlap() {
        Gpr.debug("Test");
        this.overlap("catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "catagaaaccaacagccatataactggtagctttaagcggctc", 0, "catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#################################################################");
    }

    @Test
    public void test_12_overlap() {
        Gpr.debug("Test");
        this.overlap("catagaaaccaacagccatataactggtagctttaagcggctc", "catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", 0, "catagaaaccaacagccatataactggtagctttaagcggctcacctttagcatcaacaggccacaaccaaccagaacgtgaaaaagcgtcctgcgtgtagcgaactg", "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
    }

    @Test
    public void test_13_overlap() {
        Gpr.debug("Test");
        this.overlap("caggagcaggaaagcgagggtatcctacaaagtccagcgtaccataaacgcaagcctcaacgcagcgacgagcacgagagcggtcagtagcaatccaaac", "aaagtccagcgtaccataaacgcaagcctcaacgcagcgacgagcacgagagcggtcagtagcaatccaa", 28, "caggagcaggaaagcgagggtatcctacaaagtccagcgtaccataaacgcaagcctcaacgcagcgacgagcacgagagcggtcagtagcaatccaaac", "############################&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&##");
    }

    @Test
    public void test_15_DnaCoder_copy_1() {
        Gpr.debug("Test");
        DnaCoder dnaCoder = DnaCoder.get();
        long seed = 20100809L;
        Random rand = new Random(seed);
        int numTests = 10000;
        int maxLen = 1000;
        for (int i = 1; i < numTests; ++i) {
            int srcStart;
            int seqlen = rand.nextInt(maxLen) + 10;
            String srcStr = this.randSeq(seqlen, rand);
            String dstStr = this.randSeq(seqlen, rand);
            DnaSequence src = new DnaSequence(srcStr);
            DnaSequence dst = new DnaSequence(dstStr);
            int dstStart = srcStart = rand.nextInt(src.length());
            int len = rand.nextInt(Math.min(src.length() - srcStart, dst.length() - dstStart));
            String subStr = srcStr.substring(srcStart, srcStart + len);
            String dstBefore = dst.getSequence().substring(0, dstStart);
            String dstAfter = dst.getSequence().substring(dstStart + len);
            if (verbose) {
                System.out.println("\n-----------------------------------------------------------------------------------------------");
                System.out.println("src:\t" + src);
                System.out.println("dst:\t" + dst);
                System.out.println("sub:\t" + subStr);
                System.out.println("bef:\t" + dstBefore);
                System.out.println("aft:\t" + dstAfter);
            }
            dnaCoder.copyBases(src.getCodes(), dst.getCodes(), srcStart, len);
            String subStrDst = dst.getSequence().substring(dstStart, dstStart + len);
            String dstBefore2 = dst.getSequence().substring(0, dstStart);
            String dstAfter2 = dst.getSequence().substring(dstStart + len);
            if (verbose) {
                System.out.println("\ndst:\t" + dst);
                System.out.println("sub:\t" + subStrDst);
            }
            if (!subStr.equals(subStrDst)) {
                throw new RuntimeException("Substrings do not match!");
            }
            if (!dstBefore2.equals(dstBefore)) {
                throw new RuntimeException("Substrings 'before' do not match!\n\tdstBefore:\t" + dstBefore + "\n\tdstBefore2:\t" + dstBefore2);
            }
            if (!dstAfter2.equals(dstAfter)) {
                throw new RuntimeException("Substrings 'after' do not match!");
            }
            Gpr.showMarkStderr(i, 1000);
        }
    }

    @Test
    public void test_16_DnaCoder_copy_2() {
        Gpr.debug("Test");
        long seed = 20100812L;
        Random rand = new Random(seed);
        int numTests = 100000;
        int minLen = 10;
        System.err.print("\nDnaCoder.copyBases test:");
        for (int numWords = 1; numWords < 10; ++numWords) {
            System.err.print("\n\tMax words: " + numWords + "\t");
            for (int i = 1; i < numTests; ++i) {
                int maxLen = 32 * numWords;
                int seqlensrc = Math.max(rand.nextInt(maxLen), minLen);
                int seqlendst = Math.max(rand.nextInt(maxLen), minLen);
                this.dnaCoderCopyBases(seqlensrc, seqlendst, rand);
                Gpr.showMarkStderr(i, 10000);
            }
        }
        System.err.print("\nDone.\n");
    }

    @Test
    public void test_17_overlap_rand() {
        Gpr.debug("Test");
        int numTests = 10;
        int minLen = 10;
        System.err.print("\nOverlap random test:\n");
        Random rand = new Random(20100812L);
        int maxlen = 10;
        int i = 1;
        while (maxlen < 10000) {
            for (int it = 0; it < numTests; ++it) {
                this.overlapRandTest(maxlen, minLen, rand);
            }
            Gpr.showMarkStderr(i, 1);
            maxlen += 10;
            ++i;
        }
        System.err.print("\nDone.\n");
    }

    @Test
    public void test_18_DnaCoder_score_rand() {
        Gpr.debug("Test");
        int numTests = 10;
        int minLen = 10;
        System.err.println("DnaCoder.score test:");
        DnaCoder dnaCoder = DnaCoder.get();
        DnaSubsequenceComparator<DnaSequence> comparator = new DnaSubsequenceComparator<DnaSequence>(true);
        Random rand = new Random(20100812L);
        int maxlen = 10;
        int i = 1;
        while (maxlen < 10000) {
            for (int it = 0; it < numTests; ++it) {
                this.scoreRandTest(maxlen, minLen, rand, dnaCoder, comparator);
            }
            Gpr.showMarkStderr(i, 1);
            maxlen += 10;
            ++i;
        }
        System.err.println("Done.");
    }

    @Test
    public void test_19_score_threshold_rand() {
        Gpr.debug("Test");
        int thresholdMax = 5;
        int changesMax = 6;
        int minLen = thresholdMax + changesMax + 10;
        System.err.print("\nScore (threshold) random test:\n");
        Random rand = new Random(20100821L);
        int maxLen = 10;
        int i = 1;
        while (maxLen < 10000) {
            for (int threshold = 0; threshold < thresholdMax; ++threshold) {
                for (int changes = 0; changes < changesMax; ++changes) {
                    this.scoreRandTestThreshold(maxLen, minLen, rand, threshold, changes);
                }
            }
            Gpr.showMarkStderr(i, 1);
            maxLen += 10;
            ++i;
        }
        System.err.print("\nDone.\n");
    }
}

