/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesDels
extends TestCasesBase {
    public static int N = 1000;
    boolean forcePositive;

    public TestCasesDels() {
        this.forcePositive = this.debug;
    }

    String codonsNew(Variant seqChange) {
        int cdsBaseNum = 0;
        String codonsNew = "";
        char[] currCodon = new char[3];
        boolean useCodon = false;
        currCodon[2] = 32;
        currCodon[1] = 32;
        currCodon[0] = 32;
        for (Exon exon : this.transcript.sortedStrand()) {
            int beg;
            int step2 = exon.isStrandPlus() ? 1 : -1;
            int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
            while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                int cdsCodonPos = cdsBaseNum % 3;
                if (seqChange.intersects(pos)) {
                    useCodon = true;
                } else {
                    char base = this.chromoBases[pos];
                    char c = currCodon[cdsCodonPos] = exon.isStrandPlus() ? base : GprSeq.wc(base);
                }
                if (cdsCodonPos == 2) {
                    if (useCodon) {
                        codonsNew = codonsNew + new String(currCodon);
                    }
                    useCodon = false;
                    currCodon[2] = 32;
                    currCodon[1] = 32;
                    currCodon[0] = 32;
                }
                pos += step2;
                ++cdsBaseNum;
            }
        }
        if (useCodon) {
            codonsNew = codonsNew + new String(currCodon);
        }
        return this.removeWhiteSpaces(codonsNew);
    }

    String codonsOld(Variant variant) {
        int cdsBaseNum = 0;
        String codonsOld = "";
        char[] currCodon = new char[3];
        boolean useCodon = false;
        currCodon[2] = 32;
        currCodon[1] = 32;
        currCodon[0] = 32;
        for (Exon exon : this.transcript.sortedStrand()) {
            int beg;
            int step2 = exon.isStrandPlus() ? 1 : -1;
            int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
            while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                int cdsCodonPos = cdsBaseNum % 3;
                useCodon |= variant.intersects(pos);
                char base = this.chromoBases[pos];
                char c = currCodon[cdsCodonPos] = exon.isStrandPlus() ? base : GprSeq.wc(base);
                if (cdsCodonPos == 2) {
                    if (useCodon) {
                        codonsOld = codonsOld + new String(currCodon);
                    }
                    useCodon = false;
                    currCodon[2] = 32;
                    currCodon[1] = 32;
                    currCodon[0] = 32;
                }
                pos += step2;
                ++cdsBaseNum;
            }
        }
        if (useCodon) {
            codonsOld = codonsOld + new String(currCodon);
        }
        return this.removeWhiteSpaces(codonsOld);
    }

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20100629;
    }

    String removeWhiteSpaces(String str) {
        String strNoWs = "";
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            strNoWs = strNoWs + str.charAt(i);
        }
        return strNoWs;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("DEL Test iteration: " + i + "\n" + this.transcript);
            } else if (this.verbose) {
                System.out.println("DEL Test iteration: " + i + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(i + 1, 1);
            }
            int cdsBaseNum = 0;
            String transcriptStr = this.transcript.toString() + "\n" + this.transcript.toStringAsciiArt(false);
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step2 = exon.isStrandPlus() ? 1 : -1;
                int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    String delPlus;
                    int delLen = this.rand.nextInt(10) + 1;
                    int start = pos;
                    int end = pos + delLen;
                    if (this.transcript.isStrandMinus()) {
                        start = pos - delLen;
                        end = pos;
                    }
                    if (start < 0) {
                        start = 0;
                    }
                    if (end > this.chromosome.getEnd()) {
                        end = this.chromosome.getEnd();
                    }
                    delLen = end - start + 1;
                    String del = delPlus = this.chromoSequence.substring(start, end + 1);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    Variant variant = new Variant((Marker)this.chromosome, start, "", "-" + del, "");
                    Assert.assertEquals(true, variant.isDel());
                    Assert.assertEquals(del.length(), variant.size());
                    String effectExpected = "";
                    String aaExpected = "";
                    String codonsOld = this.codonsOld(variant);
                    codonsOld = codonsOld.toUpperCase();
                    String aaOld = codonTable.aa(codonsOld);
                    String codonsNew = this.codonsNew(variant);
                    String aaNew = codonTable.aa(codonsNew);
                    String netChange = "";
                    for (Object ex : this.transcript.sortedStrand()) {
                        netChange = netChange + variant.netChange((Marker)ex);
                    }
                    if (codonsOld.isEmpty()) {
                        codonsOld = "-";
                    }
                    if (codonsNew.isEmpty()) {
                        codonsNew = "-";
                    }
                    if (aaOld.isEmpty()) {
                        aaOld = "-";
                    }
                    if (aaNew.isEmpty()) {
                        aaNew = "-";
                    }
                    if (variant.includes(exon)) {
                        effectExpected = "EXON_DELETED";
                    } else if (netChange.length() % 3 != 0) {
                        effectExpected = "FRAME_SHIFT";
                        aaExpected = "(" + aaOld + "/" + "-" + ")";
                    } else {
                        if (cdsCodonPos == 0) {
                            effectExpected = "CODON_DELETION";
                            aaExpected = "(" + aaOld + "/-)";
                        } else if (codonsOld.startsWith(codonsNew) || codonsNew.equals("-")) {
                            effectExpected = "CODON_DELETION";
                            aaExpected = "(" + aaOld + "/" + aaNew + ")";
                        } else {
                            effectExpected = "CODON_CHANGE_PLUS_CODON_DELETION";
                            aaExpected = "(" + aaOld + "/" + aaNew + ")";
                        }
                        if (cdsCodonNum == 0 && codonTable.isStartFirst(codonsOld) && !codonTable.isStartFirst(codonsNew)) {
                            effectExpected = "START_LOST";
                            aaExpected = "(" + aaOld + "/" + aaNew + ")";
                        } else if (aaOld.indexOf(42) >= 0 && aaNew.indexOf(42) < 0) {
                            effectExpected = "STOP_LOST";
                            aaExpected = "(" + aaOld + "/" + aaNew + ")";
                        } else if (aaNew.indexOf(42) >= 0 && aaOld.indexOf(42) < 0) {
                            effectExpected = "STOP_GAINED";
                            aaExpected = "(" + aaOld + "/" + aaNew + ")";
                        }
                    }
                    VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
                    if (effects.isEmpty()) {
                        System.err.println("No effects for variant: " + variant + ", expecting '" + effectExpected + "'");
                    }
                    Assert.assertEquals(false, effects.isEmpty());
                    if (this.debug && effects.size() > 1) {
                        Object ex;
                        System.out.println("Found more than one effect: " + effects.size() + "\n" + this.transcript);
                        System.out.println("\tEffects: ");
                        ex = effects.iterator();
                        while (ex.hasNext()) {
                            VariantEffect eff = (VariantEffect)ex.next();
                            System.out.println("\t" + eff);
                        }
                    }
                    boolean ok = false;
                    for (VariantEffect effect : effects) {
                        String effStr = effect.effect(true, false, true, false, false);
                        String effFullStr = effect.effect(true, true, true, false, false);
                        String line = "\tIteration: " + i + "\tPos: " + pos + "\tExpected: '" + effectExpected + "'\tEffect: '" + effStr + "'";
                        StringBuilder msg = new StringBuilder();
                        msg.append(line + "\n");
                        msg.append("\tIteration: " + i);
                        msg.append("\tPos: " + pos);
                        msg.append("\n\t\tCDS base [codon] : " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]");
                        msg.append("\n\t\tVariant          : " + variant + "\tsize: " + variant.size() + "\tdelPlus: " + delPlus);
                        msg.append("\n\t\tNetCdsChange     : " + netChange);
                        msg.append("\n\t\tEffect expected  : " + effectExpected);
                        msg.append("\n\t\tEffect           : " + effStr + "\t" + effFullStr);
                        msg.append("\n\t\tAA expected      : '" + aaOld + "' / '" + aaNew + "'\t" + aaExpected);
                        msg.append("\n\t\tAA               : '" + effect.getAaRef() + "' / '" + effect.getAaAlt() + "'");
                        msg.append("\n\t\tCodon expected   : '" + codonsOld + "' / '" + codonsNew + "'");
                        msg.append("\n\t\tCodons           : '" + effect.getCodonsRef().toUpperCase() + "' / '" + effect.getCodonsAlt().toUpperCase() + "'");
                        msg.append("\n\nTranscript:\n" + transcriptStr + "\n");
                        msg.append(line + "\n");
                        if (this.debug) {
                            System.out.println(msg);
                        } else if (this.verbose) {
                            System.out.println(line);
                        }
                        for (String e : effStr.split("\\+")) {
                            String codonsNewEff;
                            if (!effectExpected.equals(e)) continue;
                            ok = true;
                            if (effect.getEffectType() == EffectType.FRAME_SHIFT || effect.getEffectType() == EffectType.EXON_DELETED || effect.getEffectType() == EffectType.SPLICE_SITE_REGION || effect.getEffectType() == EffectType.INTERGENIC) continue;
                            if (codonsNew.equals("-")) {
                                codonsNew = "";
                            }
                            if ((codonsNewEff = effect.getCodonsAlt().toUpperCase()).equals("-")) {
                                codonsNewEff = "";
                            }
                            Assert.assertTrue(msg.toString(), codonsOld.equals(effect.getCodonsRef().toUpperCase()));
                            Assert.assertTrue(msg.toString(), codonsNew.equals(codonsNewEff));
                        }
                    }
                    if (!ok) {
                        System.err.println("Cannot find '" + effectExpected + "'");
                    }
                    Assert.assertEquals(true, ok);
                    pos += step2;
                    ++cdsBaseNum;
                }
            }
        }
        System.err.println("");
    }
}

