/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesDel {
    public static int N = 1000;
    boolean debug;
    boolean verbose;

    public TestCasesDel() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_02() {
        Exon[] exons;
        new Config("test");
        String chrSeq = "CGTGTTACCAAGCATTTGGGAACCGGAATTCTACGCTGGAGTTCGCCTAACAGCTAAAGCTCAAAACAGGAGTGGTTTAGTTCACAGGCAGACCTTTAACGGTACCTACCTTAATCCGGTCAGATTTAAATTCATGATAGATGGTCTAAGTCATGCACTACTCCTACCAGTTTTGGACGTGGCGCATTGGGCCCCGACACCAAATGCGTTGGAGCGACAGCACAAACGATATCTCAGATTAAGTGCATTGAAGGCCTTCTCACGGATAGATCTATAGGTCGCTGTGTGTCGGGAAGTCTTTCATCCGCTCGGGAGTCGGGTAAATTCTTTCTTCCAGTTGTGTGTTCTACGACTGCAGAGGACAGCTCTCGCTTAGTTTCCTTCCGTTCTTTGTAAGGCCCGATAGGAATACCCGCATAATTATCCCCACAGTCTAACTTGATCCACGTCATATGGGGCGATGGCTGGAATGAGGGGGGTTCAGTGGCAGACCACGATATCTCTGTTTATCTGATGAAGAATTTTGGATACCCCAATAACTAATGTGAGAAGAGTGTGGGGTATCCAACGTGATTGGAGGGAAGTATGGAAACGAATGAAGACAAGTTCGACAAGCCGTGGTAACGATCATATGCCACCGTATTCTAACGGGGGGGGGCCGCTGTTTGAATGCCAGATAGATATTTAAAGAGGATGGCCGCCCCCCAATGGGCACGAGGAACTGACCAGAGGTAGGTATGATGGTGTGAGAGAGAGATGTAGTGTAGTTACTATAAAGATTTGAAGATCGAAAGGCTTAGTGATACGAAACCTCCCGCTACTGCGGGCCGGTATAGCAGGTCTAATACTTGGTGATAGGGCTACATCGAGCCTCGTTCGACAAGAATACCCCAGTTGCAATGGGGACCGATTCAGTCTGGGGCTCTGTGGTCCGACATTATGCCGGAATGCCTAGTATGGGAATTAAAACGATTAATATTACCTCTGGGACTATCTTTGTGCCAAACTCTACTGAGAGAGGAACGTAATCGTATTAGGGGCCAAGATAGTTTACTCCGATCCACCGTAACACTTATTTTGGGCCGTGCGTACCCACCCACGGTCATGAACGCAAACTGGATAGGGCGCGTCATACGAGCTAAAGTGTTCTCTTGGGGCAAATAAGAAGGGACTAGCTGTATTCCCCTCCCATTGTGTGGGTACAATTCGGGGGAAAGGTGTCGAGCCCAAATGCTACGGCTCGTAGATATCAGGTCCTTTAGCCGCCCGTATGTAAGCACCTCCAACGTTTTGGAGGAAGATCCCTCTCCCACGGGTTATACCATTAATGACTCCGCACTAACAATATCTTACCAGGGCCCGCAAATACCACACCGGGATACTGGAATGAATTATTCTCCGACCCATTTGATGAAACGTATGGGAACTTTCCTGTTGTATTAAACCCGCGGATACACTCTCTTGCCCACGAGTAGCCTCTACTTACTAGATTGAGAGGTACACTACGCCATTATGAAGCATTTCGACTTTCACTCCAGTATATAGAAGGTATGTGTGGATCCTTCAAAATAGTGATCCGAACCTGGTTGTAGGGGCCACCGAAATTCCGATTACTGAAGATTAATGTTTTCAAATGCCCTATTTCACTGGTGATAGCGATGGAGCCGGGCTATCATCATGGCGAAGCACGTGGGAAAGCATTCCGTCAAGGCTAGTGGGAACCTCTGCCTTGCCATGTACGCGTTCTATATACACGAACATCGATACCGGTCTCGTCCTGGGGTAGAGCCATCCTCATCACGAGTGATGTAGGACGGCTAGCTCATTAATTCACTGCGTGTCAGATAGAATGTCTTCGTGCGCAAAAATTGTTTAGGAGACCGTCGGCGCTCCCTTGGAGAGATGCCCAACGTAGAGAGGCAATCCCCGGCGTATTGGTGGTTTCTGGAACGGAACGAGACTCTTTGTTGCGTCGACTCCCGGCAACACCGGCCCCCGCCG";
        Genome genome = new Genome("test");
        Chromosome chr = new Chromosome(genome, 0, chrSeq.length() - 1, "1");
        chr.setSequence(chrSeq);
        genome.add(chr);
        Gene gene = new Gene(chr, 333, 408, true, "gene1", "gene1", "protein_coding");
        Transcript tr = new Transcript(gene, 333, 408, true, "tr1");
        gene.add(tr);
        tr.setProteinCoding(true);
        Exon e1 = new Exon(tr, 333, 334, true, "exon1", 0);
        Exon e2 = new Exon(tr, 353, 364, true, "exon2", 0);
        Exon e3 = new Exon(tr, 388, 398, true, "exon3", 0);
        Exon e4 = new Exon(tr, 404, 408, true, "exon4", 0);
        for (Exon e : exons = new Exon[]{e1, e2, e3, e4}) {
            String seq2 = chrSeq.substring(e.getStart(), e.getEnd() + 1);
            seq2 = GprSeq.reverseWc(seq2);
            e.setSequence(seq2);
            tr.add(e);
            Cds cds = new Cds(tr, e.getStart(), e.getEnd(), e.isStrandMinus(), "");
            tr.add(cds);
        }
        tr.rankExons();
        if (this.verbose) {
            System.out.println("Transcript:\n" + tr);
        }
        Assert.assertEquals("FLPYKAVLCR", tr.protein());
        Variant var = new Variant((Marker)chr, 397, "GCCCGATAGGA", "", "");
        if (this.verbose) {
            System.out.println("Variant: " + var);
        }
        Assert.assertEquals("chr1:397_GCCCGATAGGA/", var.toString());
        SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(genome);
        snpEffectPredictor.setUpDownStreamLength(0);
        snpEffectPredictor.add(gene);
        snpEffectPredictor.buildForest();
        VariantEffects effectsAll = snpEffectPredictor.variantEffect(var);
        for (VariantEffect eff : effectsAll) {
            if (eff.getEffectType() != EffectType.CODON_CHANGE_PLUS_CODON_DELETION) continue;
            if (this.verbose) {
                System.out.println("\t" + eff.getEffectTypeString(false) + "\t" + eff.getCodonsRef() + "\t" + eff.getCodonsAlt());
            }
            Assert.assertEquals("TCT", eff.getCodonsAlt().toUpperCase());
        }
    }
}

