/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.align.NeedlemanWunsch;
import ca.mcgill.mcb.pcingola.align.VcfRefAltAlign;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesAlign {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] as = new String[]{"TTT", "TTTGTT", "GCG", "G"};
        String[] bs = new String[]{"TTTGTT", "TTT", "G", "GCG"};
        String[] res = new String[]{"-GTT", "+GTT", "+CG", "-CG"};
        int[] offset = new int[]{3, 3, 1, 1};
        for (int i = 0; i < as.length; ++i) {
            String a = as[i];
            String b = bs[i];
            NeedlemanWunsch align = new NeedlemanWunsch(a, b);
            if (this.verbose) {
                System.out.println("---------------------------------------- " + align.getClass().getSimpleName() + ": " + i + " ----------------------------------------");
            }
            align.align();
            if (this.verbose) {
                System.out.println("a    : '" + a + "'\nb    : '" + b + "'\nAlign: '" + align.getAlignment() + "'" + "\tOffset: " + align.getOffset() + "\n");
            }
            Assert.assertEquals(res[i], align.getAlignment());
            Assert.assertEquals(offset[i], align.getOffset());
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] as = new String[]{"TTT", "TTTGTT", "GCG", "G"};
        String[] bs = new String[]{"TTTGTT", "TTT", "G", "GCG"};
        String[] res = new String[]{"-GTT", "+GTT", "+CG", "-CG"};
        int[] offset = new int[]{3, 3, 1, 1};
        for (int i = 0; i < as.length; ++i) {
            String a = as[i];
            String b = bs[i];
            VcfRefAltAlign align = new VcfRefAltAlign(a, b);
            if (this.verbose) {
                System.out.println("---------------------------------------- " + align.getClass().getSimpleName() + ": " + i + " ----------------------------------------");
            }
            align.align();
            if (this.verbose) {
                System.out.println("a    : '" + a + "'\nb    : '" + b + "'\nAlign: '" + align.getAlignment() + "'" + "\tOffset: " + align.getOffset() + "\n");
            }
            Assert.assertEquals(res[i], align.getAlignment());
            Assert.assertEquals(offset[i], align.getOffset());
        }
    }
}

