/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesTranscriptError {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "testHg3763Chr20", "./tests/short_codon_bug.vcf"};
        this.transcriptError(args, VariantEffect.ErrorWarningType.WARNING_TRANSCRIPT_INCOMPLETE);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "testHg3763Chr20", "./tests/incorrect_ref.vcf"};
        this.transcriptError(args, VariantEffect.ErrorWarningType.WARNING_REF_DOES_NOT_MATCH_GENOME);
    }

    void transcriptError(String[] args, VariantEffect.ErrorWarningType warningType) {
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.snpEffCmd();
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = snpeff.run(true);
        boolean hasWarning = false;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                VariantEffect.EffectImpact imp = veff.getImpact();
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)imp) + "\t" + veff);
                }
                if (veff.getErrorsWarning() == null) continue;
                hasWarning |= veff.getErrorsWarning().indexOf(warningType.toString()) >= 0;
            }
        }
        Assert.assertEquals(true, hasWarning);
    }
}

