/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesSequenceOntology {
    public static boolean debug;
    public static boolean verbose;

    public static void createDelFile(String genomeName, String outFile, double prob) throws IOException {
        Config config = new Config(genomeName, Gpr.HOME + "/snpEff/" + "snpEff.config");
        config.loadSnpEffectPredictor();
        Random rand = new Random(20140129L);
        StringBuilder out = new StringBuilder();
        int count2 = 0;
        for (Gene g : config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    for (int i = e.getStart(); i < e.getEnd(); ++i) {
                        if (!(rand.nextDouble() < prob)) continue;
                        int delLen = rand.nextInt(10) + 2;
                        if (i + delLen > e.getEnd()) {
                            delLen = e.getEnd() - i;
                        }
                        if (delLen < 2) continue;
                        int idx = i - e.getStart();
                        String ref = e.basesAt(idx, delLen);
                        String alt = ref.substring(0, 1);
                        int pos = i + 1;
                        String line = e.getChromosomeName() + "\t" + pos + "\t.\t" + ref + "\t" + alt + "\t.\t.\tAC=1\tGT\t0/1";
                        if (verbose) {
                            System.out.println(line);
                        }
                        out.append(line + "\n");
                        ++count2;
                    }
                }
            }
        }
        if (verbose) {
            System.err.println("Count:" + count2);
            System.out.println("Output file: " + outFile);
        }
        Gpr.toFile(outFile, out);
    }

    public static void createInsFile(String genomeName, String outFile, double prob) throws IOException {
        Config config = new Config(genomeName, Gpr.HOME + "/snpEff/" + "snpEff.config");
        config.loadSnpEffectPredictor();
        Random rand = new Random(20140129L);
        StringBuilder out = new StringBuilder();
        int count2 = 0;
        for (Gene g : config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    for (int i = e.getStart(); i < e.getEnd(); ++i) {
                        if (!(rand.nextDouble() < prob)) continue;
                        int insLen = rand.nextInt(10) + 1;
                        if (i + insLen > e.getEnd()) {
                            insLen = e.getEnd() - i;
                        }
                        int idx = i - e.getStart();
                        String ref = e.basesAt(idx, 1);
                        String alt = ref + GprSeq.randSequence(rand, insLen);
                        int pos = i + 1;
                        String line = e.getChromosomeName() + "\t" + pos + "\t.\t" + ref + "\t" + alt + "\t.\t.\tAC=1\tGT\t0/1";
                        if (verbose) {
                            System.out.println(line);
                        }
                        out.append(line + "\n");
                        ++count2;
                    }
                }
            }
        }
        if (verbose) {
            System.err.println("Count:" + count2);
            System.out.println("Output file: " + outFile);
        }
        Gpr.toFile(outFile, out);
    }

    public static void createMnpFile(String genomeName, String outFile, double prob) throws IOException {
        Config config = new Config(genomeName, Gpr.HOME + "/snpEff/" + "snpEff.config");
        config.loadSnpEffectPredictor();
        Random rand = new Random(20140129L);
        StringBuilder out = new StringBuilder();
        int count2 = 0;
        for (Gene g : config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    for (int i = e.getStart(); i < e.getEnd(); ++i) {
                        if (!(rand.nextDouble() < prob)) continue;
                        int mnpLen = rand.nextInt(10) + 1;
                        if (i + mnpLen > e.getEnd()) {
                            mnpLen = e.getEnd() - i;
                        }
                        if (mnpLen < 2) continue;
                        int idx = i - e.getStart();
                        String ref = e.basesAt(idx, mnpLen);
                        String alt = GprSeq.randSequence(rand, mnpLen);
                        while (ref.equals(alt)) {
                            alt = GprSeq.randSequence(rand, mnpLen);
                        }
                        int pos = i + 1;
                        String line = e.getChromosomeName() + "\t" + pos + "\t.\t" + ref + "\t" + alt + "\t.\t.\tAC=1\tGT\t0/1";
                        if (verbose) {
                            System.out.println(line);
                        }
                        out.append(line + "\n");
                        ++count2;
                    }
                }
            }
        }
        if (verbose) {
            System.err.println("Count:" + count2);
            System.out.println("Output file: " + outFile);
        }
        Gpr.toFile(outFile, out);
    }

    public static void createSnpFile(String genomeName, String outFile) throws IOException {
        Config config = new Config(genomeName, Gpr.HOME + "/snpEff/" + "snpEff.config");
        config.loadSnpEffectPredictor();
        Random rand = new Random(20140205L);
        StringBuilder out = new StringBuilder();
        int count2 = 0;
        for (Gene g : config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    for (int i = e.getStart(); i < e.getEnd(); ++i) {
                        String ref;
                        if (!(rand.nextDouble() < 0.15)) continue;
                        int idx = i - e.getStart();
                        String alt = ref = e.basesAt(idx, 1);
                        while (alt.equals(ref)) {
                            alt = GprSeq.randSequence(rand, 1);
                        }
                        String line = e.getChromosomeName() + "\t" + (i + 1) + "\t.\t" + ref + "\t" + alt + "\t.\t.\tAC=1\tGT\t0/1";
                        if (verbose) {
                            System.out.println(line);
                        }
                        out.append(line + "\n");
                        ++count2;
                    }
                }
            }
        }
        if (verbose) {
            System.err.println("Count:" + count2);
            System.out.println("Output file: " + outFile);
        }
        Gpr.toFile(outFile, out);
    }

    public void compareVepSO(String genome, String vcf, String trId) {
        String[] args = new String[]{"-classic", "-sequenceOntology", genome, vcf};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(verbose);
        cmdEff.setSupressOutput(!verbose);
        List<VcfEntry> vcfEnties = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEnties) {
            HashSet<String> vepSos = new HashSet<String>();
            String vepSo = ve.getInfo("SO");
            for (String so : vepSo.split(",")) {
                if (so.equals("feature_elongation")) {
                    so = null;
                } else if (so.equals("feature_truncation")) {
                    so = null;
                }
                if (so == null) continue;
                vepSos.add(so);
            }
            HashSet<String> effSos = new HashSet<String>();
            List<VcfEffect> veffs = ve.parseEffects();
            for (VcfEffect veff : veffs) {
                if (!veff.getTranscriptId().equals(trId)) continue;
                String effs = veff.getEffString();
                for (String eff : effs.split("\\+")) {
                    if (eff.equals("5_prime_UTR_premature_start_codon_gain_variant")) {
                        eff = "5_prime_UTR_variant";
                    }
                    if (eff.equals("disruptive_inframe_insertion")) {
                        eff = "inframe_insertion";
                    }
                    if (eff.equals("start_lost")) {
                        eff = "initiator_codon_variant";
                    }
                    effSos.add(eff);
                }
            }
            boolean error = !effSos.containsAll(vepSos);
            if (!error) continue;
            String msg = "\n" + ve;
            msg = msg + "\n\tSnpEff    : ";
            for (String e : effSos) {
                msg = msg + e + " ";
            }
            msg = msg + "\n\tVEP       : ";
            for (String e : vepSos) {
                msg = msg + e + " ";
            }
            msg = msg + "\n\tMarker    : " + ve.getChromosomeName() + ":" + ve.getStart() + "-" + ve.getEnd();
            Gpr.debug(msg);
            throw new RuntimeException(msg);
        }
    }

    @Test
    public void test_01_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000268124", "tests/testENST00000268124.SNP.vcf", "ENST00000268124");
    }

    @Test
    public void test_02_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000268124", "tests/testENST00000268124.SNP.02.vcf", "ENST00000268124");
    }

    @Test
    public void test_03_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000268124", "tests/testENST00000268124.Ins.03.vcf", "ENST00000268124");
    }

    @Test
    public void test_04_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000398332", "tests/testENST00000398332.Ins.04.vcf", "ENST00000398332");
    }

    @Test
    public void test_05_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000268124", "tests/testENST00000268124.Del.05.vcf", "ENST00000268124");
    }

    @Test
    public void test_06_Vep() throws IOException {
        Gpr.debug("Test");
        this.compareVepSO("testENST00000268124", "tests/testENST00000268124.Mnp.06.vcf", "ENST00000268124");
    }

    static {
        verbose = debug = false;
    }
}

