/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesRegulation {
    boolean debug;
    boolean verbose;

    public TestCasesRegulation() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr22";
        String vcfFileName = "tests/test_regulatory_01.vcf";
        String cellType = "HepG2";
        String dbFileName = "data/" + genome + "/regulation_" + cellType + ".bin";
        if (this.verbose) {
            System.err.println("Deleting file '" + dbFileName + "'");
        }
        File f2 = new File(dbFileName);
        f2.delete();
        String[] argsBuild = new String[]{"build", "-onlyReg", "-noLog", genome};
        SnpEff snpeffBuild = new SnpEff(argsBuild);
        snpeffBuild.setDebug(this.debug);
        snpeffBuild.setVerbose(this.verbose);
        snpeffBuild.setSupressOutput(!this.verbose);
        boolean ok = snpeffBuild.run();
        Assert.assertTrue("Error building regulatory regions", ok);
        String[] argsRun = new String[]{genome, vcfFileName};
        SnpEffCmdEff snpeffRun = new SnpEffCmdEff();
        snpeffRun.parseArgs(argsRun);
        snpeffRun.setDebug(this.debug);
        snpeffRun.setVerbose(this.verbose);
        snpeffRun.setSupressOutput(!this.verbose);
        snpeffRun.addRegulationTrack(cellType);
        List<VcfEntry> vcfEntries = snpeffRun.run(true);
        ok = false;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (this.verbose) {
                    System.out.println("\t" + veff + "\t\t" + veff.getFeatureType());
                }
                ok |= veff.getFeatureType().equals("REGULATION&H3K27me3:HepG2");
            }
        }
        Assert.assertTrue("Error annotating regulatory regions", ok);
    }
}

