/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.align.SmithWaterman;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdBuild;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesRefSeq {
    boolean debug = false;
    boolean verbose = false;

    public SnpEffectPredictor buildAndCompare(String genome, String refSeqFile, String fastaFile, String resultFile) {
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryRefSeq factory = new SnpEffPredictorFactoryRefSeq(config);
        factory.setFileName(refSeqFile);
        factory.setVerbose(this.verbose);
        if (fastaFile != null) {
            factory.setFastaFile(fastaFile);
        } else {
            factory.setReadSequences(false);
        }
        SnpEffectPredictor sep = factory.create();
        String result2 = this.show(sep.getGenome()).trim();
        if (this.verbose) {
            System.out.println(result2);
        }
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
        return sep;
    }

    String show(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        Collections.sort(genes);
        for (Gene gene : genes) {
            for (Transcript tr : gene.sortedStrand()) {
                tr.setProteinCoding(false);
            }
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "hg19";
        String refSeqFile = "tests/hg19_refSeq_OR4F16.txt";
        String fastaFile = null;
        String resultFile = "tests/hg19_refSeq_OR4F16.dump.txt";
        SnpEffectPredictor sep = this.buildAndCompare(genome, refSeqFile, fastaFile, resultFile);
        sep.buildForest();
        Variant seqChange = new Variant((Marker)sep.getGenome().getChromosome("1"), 521603, "A", "G");
        VariantEffects effs = sep.variantEffect(seqChange);
        for (VariantEffect eff : effs) {
            if (this.verbose) {
                System.out.println("\t" + eff);
            }
            Assert.assertEquals((Object)eff.getEffectType(), (Object)EffectType.INTERGENIC);
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genome = "testNM_015296";
        String[] args = new String[]{"build", genome};
        SnpEff snpeff = new SnpEff(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        SnpEffCmdBuild snpeffBuild = (SnpEffCmdBuild)snpeff.snpEffCmd();
        snpeffBuild.setStoreAlignments(true);
        snpeffBuild.run();
        HashMap<String, SmithWaterman> alignmentByTrId = snpeffBuild.getSnpEffCmdProtein().getAlignmentByTrId();
        SmithWaterman sw = alignmentByTrId.get("NM_015296.2");
        if (this.debug) {
            Gpr.debug(sw.getAlignmentScore() + "\n" + sw);
        }
        Assert.assertTrue(sw.getAlignmentScore() >= 2061);
    }
}

