/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesMotif {
    public static boolean debug;
    public static boolean verbose;
    public static int SHOW_EVERY;

    void checkMotif(String genomeVer, String vcfFile, String effectDetails, VariantEffect.EffectImpact impact, boolean useAnn) {
        String[] args = new String[]{"-classic", "-motif", "-ud", "0", genomeVer, vcfFile};
        String[] argsAnn = new String[]{"-ud", "0", genomeVer, vcfFile};
        if (useAnn) {
            args = argsAnn;
        }
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(verbose);
        cmdEff.setSupressOutput(!verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        int numNextProt = 0;
        for (VcfEntry ve : vcfEntries) {
            for (VcfEffect veff : ve.parseEffects()) {
                if (verbose) {
                    System.out.println("\t" + veff.getVcfFieldString());
                }
                if (veff.getEffectType() != EffectType.MOTIF) continue;
                boolean ok = false;
                if (useAnn) {
                    ok = effectDetails.equals(veff.getFeatureId()) && impact == veff.getImpact();
                } else {
                    boolean bl = ok = effectDetails.equals(veff.getEffectDetails()) && impact == veff.getImpact();
                }
                if (!ok) continue;
                ++numNextProt;
            }
        }
        Assert.assertEquals(1L, numNextProt);
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_01.vcf", "MA0099.2:AP1", VariantEffect.EffectImpact.LOW, false);
    }

    @Test
    public void test_01_ann() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_01.vcf", "MA0099.2", VariantEffect.EffectImpact.LOW, true);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_02.vcf", "MA0099.2:AP1", VariantEffect.EffectImpact.MODIFIER, false);
    }

    @Test
    public void test_02_ann() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_02.vcf", "MA0099.2", VariantEffect.EffectImpact.MODIFIER, true);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_03.vcf", "MA0099.2:AP1", VariantEffect.EffectImpact.LOW, false);
    }

    @Test
    public void test_03_ann() {
        Gpr.debug("Test");
        this.checkMotif("testHg3770Chr22", "tests/test_motif_03.vcf", "MA0099.2", VariantEffect.EffectImpact.LOW, true);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr11";
        String vcf = "tests/craig_chr11.vcf";
        String[] args = new String[]{"-noLog", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(verbose);
        snpEff.setSupressOutput(!verbose);
        snpEff.setDebug(debug);
        snpEff.run();
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr14";
        String vcf = "tests/craig_chr14.vcf";
        String[] args = new String[]{"-noLog", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(verbose);
        snpEff.setSupressOutput(!verbose);
        snpEff.setDebug(debug);
        snpEff.run();
    }

    static {
        verbose = debug = false;
        SHOW_EVERY = 10;
    }
}

