/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.integration.CompareToVep;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesMixedVariants {
    boolean debug;
    boolean verbose;

    public TestCasesMixedVariants() {
        this.verbose = this.debug = false;
    }

    public void compareVep(String genome, String vcf) {
        CompareToVep comp = new CompareToVep(genome, this.verbose);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_01_MixedVep() {
        Gpr.debug("Test");
        String vcfFile = "tests/mixed_01.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (Variant var : ve.variants()) {
                if (!this.verbose) continue;
                System.out.println("\t" + var);
            }
        }
    }

    @Test
    public void test_02_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr22", "tests/mixed_chr22.vcf");
    }

    @Test
    public void test_03_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr14", "tests/mixed_chr14.vcf");
    }

    @Test
    public void test_04_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr12", "tests/mixed_chr12.vcf");
    }

    @Test
    public void test_05_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr22", "tests/mixed_chr22.vcf");
    }

    @Test
    public void test_06_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr7", "tests/mixed_chr7.vcf");
    }

    @Test
    public void test_07_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr6", "tests/mixed_chr6.vcf");
    }

    @Test
    public void test_08_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr1", "tests/mixed_chr1.vcf");
    }

    @Test
    public void test_09_MixedVep() {
        Gpr.debug("Test");
        String vcfFileName = "tests/mixed_09.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (Variant v : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t\t" + v);
                }
                Assert.assertTrue("Variant is not MIXED", v.getVariantType() == Variant.VariantType.MIXED);
            }
        }
    }
}

