/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;

public class TestCasesLof {
    public static boolean debug;
    public static boolean verbose;
    public static final int NUM_DEL_TEST = 10;
    Config config;
    Random random = new Random(20121030L);

    @After
    public void after() {
        this.config = null;
    }

    Marker cdsMarker(Transcript tr) {
        int start = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int end = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        return new Marker(tr.getParent(), start, end, false, "");
    }

    LinkedList<VariantEffect> changeEffects(Variant variant, EffectType effectType, Marker marker) {
        VariantEffect changeEffect = new VariantEffect(variant);
        changeEffect.set(marker, effectType, effectType.effectImpact(), "");
        LinkedList<VariantEffect> changeEffects = new LinkedList<VariantEffect>();
        changeEffects.add(changeEffect);
        return changeEffects;
    }

    void checkLof(Transcript tr) {
        if (!tr.isProteinCoding()) {
            return;
        }
        this.checkLofSplice(tr);
        this.checkLofStartLost(tr);
        this.checkLofExonDeleted(tr);
        this.checkLofFrameShift(tr);
    }

    void checkLofExonDeleted(Transcript tr) {
        this.checkLofExonDeletedFirstExon(tr);
        this.checkLofExonDeletedHalf(tr);
    }

    void checkLofExonDeletedFirstExon(Transcript tr) {
        Exon ex = tr.getFirstCodingExon();
        Variant seqChange = new Variant((Marker)tr.getChromosome(), ex.getStart(), "AC", "A");
        seqChange.setStart(ex.getStart());
        seqChange.setEnd(ex.getEnd());
        seqChange.setVariantType(Variant.VariantType.DEL);
        if (verbose) {
            Gpr.debug("SeqChange:" + seqChange);
        }
        LinkedList<VariantEffect> changeEffects = this.changeEffects(seqChange, EffectType.EXON_DELETED, ex);
        LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals(true, islof);
    }

    void checkLofExonDeletedHalf(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        for (int i = 0; i < 10; ++i) {
            int delStart = this.random.nextInt(tr.size() - 1) + tr.getStart();
            int delEnd = this.random.nextInt(tr.getEnd() - delStart) + delStart + 1;
            Variant seqChange = new Variant((Marker)tr.getChromosome(), delStart, "AC", "A");
            seqChange.setStart(delStart);
            seqChange.setEnd(delEnd);
            if (verbose) {
                Gpr.debug("SeqChange:" + seqChange);
            }
            seqChange.setVariantType(Variant.VariantType.DEL);
            Marker codingDel = cds.intersect(seqChange);
            if (codingDel == null) continue;
            int numBases = 0;
            for (Exon ex : tr) {
                numBases += codingDel.intersectSize(ex);
            }
            double perc = (double)numBases / (double)tr.cds().length();
            boolean delIsLof = perc > 0.5;
            LinkedList<VariantEffect> changeEffects = this.changeEffects(seqChange, EffectType.TRANSCRIPT, tr);
            LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
            boolean islof = lof.isLof();
            Assert.assertEquals(delIsLof, islof);
        }
    }

    void checkLofFrameShift(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        int codingBase = 0;
        for (Exon ex : tr.sortedStrand()) {
            int start = tr.isStrandPlus() ? ex.getStart() : ex.getEnd();
            int step2 = tr.isStrandPlus() ? 1 : -1;
            int pos = start;
            while (ex.intersects(pos)) {
                boolean ins = this.random.nextBoolean();
                Variant seqChange = ins ? new Variant((Marker)tr.getChromosome(), pos, "A", "AC") : new Variant((Marker)tr.getChromosome(), pos, "AC", "A");
                seqChange.setVariantType(ins ? Variant.VariantType.INS : Variant.VariantType.DEL);
                if (verbose) {
                    Gpr.debug("SeqChange:" + seqChange);
                }
                LinkedList<VariantEffect> changeEffects = this.changeEffects(seqChange, EffectType.FRAME_SHIFT, ex);
                VariantEffect changeEffect = changeEffects.get(0);
                changeEffect.setCodons("", "", codingBase / 3, codingBase % 3);
                int aaLen = changeEffect.getAaLength();
                boolean isFsLof = false;
                if (cds.intersects(pos)) {
                    double perc = (double)(codingBase / 3) / (double)aaLen;
                    isFsLof = 0.05 <= perc && perc <= 0.95;
                    ++codingBase;
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(isFsLof, islof);
                pos += step2;
            }
        }
    }

    void checkLofSplice(Transcript tr) {
        for (Intron intron : tr.introns()) {
            this.checkSpliceDonor(tr, intron);
            this.checkSpliceAcceptor(tr, intron);
        }
    }

    void checkLofStartLost(Transcript tr) {
        int pos = tr.getCdsStart();
        Variant seqChange = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
        if (verbose) {
            Gpr.debug("SeqChange:" + seqChange);
        }
        Exon exon = null;
        for (Exon ex : tr) {
            if (!ex.intersects(pos)) continue;
            exon = ex;
        }
        if (exon == null) {
            throw new RuntimeException("Cannot find first exon for transcript " + tr.getId());
        }
        LinkedList<VariantEffect> changeEffects = this.changeEffects(seqChange, EffectType.START_LOST, exon);
        LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals(true, islof);
    }

    void checkSpliceAcceptor(Transcript tr, Intron intron) {
        int step2;
        int n = step2 = tr.isStrandPlus() ? 1 : -1;
        if (intron.getRank() > 1) {
            int posDonor = tr.isStrandPlus() ? intron.getEnd() : intron.getStart();
            int maxSize = Math.min(intron.size(), 2);
            posDonor -= step2 * (maxSize - 1);
            if (verbose) {
                Gpr.debug("Intron size: " + intron.size());
            }
            if (maxSize <= 0) {
                throw new RuntimeException("Max splice size is " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                Variant seqChange = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
                Marker marker = this.findMarker(seqChange, EffectType.SPLICE_SITE_ACCEPTOR, null, intron);
                LinkedList<VariantEffect> changeEffects = this.changeEffects(seqChange, EffectType.SPLICE_SITE_ACCEPTOR, marker);
                if (verbose) {
                    Gpr.debug("SeqChange:" + seqChange);
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(true, islof);
                ++i;
                pos += step2;
            }
        }
    }

    void checkSpliceDonor(Transcript tr, Intron intron) {
        int step2 = tr.isStrandPlus() ? 1 : -1;
        int maxRank = tr.numChilds();
        if (intron.getRank() < maxRank) {
            int posDonor = tr.isStrandPlus() ? intron.getStart() : intron.getEnd();
            int maxSize = Math.min(intron.size(), 2);
            if (verbose) {
                Gpr.debug("Intron size: " + intron.size() + "\tmaxSize: " + maxSize);
            }
            if (maxSize <= 0) {
                throw new RuntimeException("Max splice size is non-positive: " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                if (verbose) {
                    Gpr.debug("Position: " + tr.getChromosome().getId() + ":" + posDonor);
                }
                Variant variant = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
                Marker marker = this.findMarker(variant, EffectType.SPLICE_SITE_DONOR, null, intron);
                LinkedList<VariantEffect> changeEffects = this.changeEffects(variant, EffectType.SPLICE_SITE_DONOR, marker);
                if (verbose) {
                    Gpr.debug("SeqChange:" + variant);
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(true, islof);
                ++i;
                pos += step2;
            }
        }
    }

    Marker findMarker(Variant variant, EffectType effectType, Transcript tr, Marker markerFilter) {
        Markers markers = this.config.getSnpEffectPredictor().queryDeep(variant);
        for (Marker m : markers) {
            Marker mfilter = null;
            if (markerFilter != null) {
                mfilter = (Marker)m.findParent(markerFilter.getClass());
            }
            Transcript mtr = (Transcript)m.findParent(Transcript.class);
            if (debug) {
                Gpr.debug("\tLooking for '" + (Object)((Object)effectType) + "' in '" + (markerFilter != null ? markerFilter.getId() : "NULL") + "', class: " + (markerFilter != null ? markerFilter.getClass().getSimpleName() : "") + "\t\tFound: '" + (Object)((Object)m.getType()) + "', mfilter: " + (mfilter != null ? mfilter.getId() : "NULL") + ", parent: " + m.getParent().getClass().getSimpleName());
            }
            if (m.getType() != effectType || mfilter == null || mtr == null) continue;
            if (markerFilter != null) {
                if (!mfilter.getId().equals(markerFilter.getId())) continue;
                return m;
            }
            if (tr != null) {
                if (!mtr.getId().equals(tr.getId())) continue;
                return m;
            }
            return m;
        }
        throw new RuntimeException("Cannot find '" + (Object)((Object)effectType) + "' " + (markerFilter != null ? "for exon " + markerFilter.getId() : "") + ", seqChange: " + variant);
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeVer = "testHg3766Chr1";
        this.config = new Config(genomeVer, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        this.config.setTreatAllAsProteinCoding(true);
        this.config.getSnpEffectPredictor().buildForest();
        int i = 1;
        for (Gene gene : this.config.getGenome().getGenes()) {
            Gpr.showMark(i++, 10);
            for (Transcript tr : gene) {
                if (verbose) {
                    System.err.println(tr);
                }
                this.checkLof(tr);
            }
        }
    }

    @Test
    public void test_02() {
        String[] args = new String[]{"testHg3775Chr22", "-noLog", "-i", "bed", "tests/test_lof_02.bed"};
        SnpEff snpeff = new SnpEff(args);
        snpeff.setVerbose(verbose);
        snpeff.setSupressOutput(!verbose);
        boolean ok = snpeff.run();
        Assert.assertEquals(true, ok);
    }

    static {
        verbose = debug = false;
    }
}

