/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesInsVep {
    public static boolean debug;
    public static boolean verbose;

    public void compareVep(String genome, String vcf, String trId) {
        String[] args = new String[]{"-classic", genome, vcf};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setSupressOutput(!verbose);
        List<VcfEntry> vcfEnties = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEnties) {
            StringBuilder msg = new StringBuilder();
            boolean ok = false;
            for (VcfEffect veff : ve.parseEffects()) {
                String eff;
                if (veff.getTranscriptId() == null || !veff.getTranscriptId().equals(trId)) continue;
                String vep = ve.getInfo("EFF_V");
                if (vep.equals(eff = veff.getEffectType().toString())) {
                    ok = true;
                    continue;
                }
                if (vep.equals("CODON_INSERTION") && eff.equals("CODON_CHANGE_PLUS_CODON_INSERTION")) {
                    ok = true;
                    continue;
                }
                if (vep.equals("STOP_GAINED,CODON_INSERTION") && eff.equals("STOP_GAINED")) {
                    ok = true;
                    continue;
                }
                if (eff.equals("SPLICE_SITE_REGION")) {
                    ok = true;
                    continue;
                }
                String line = "\n" + ve + "\n\tSnpEff:" + veff + "\n\tVEP   :" + ve.getInfo("EFF_V") + "\t" + ve.getInfo("AA") + "\t" + ve.getInfo("CODON") + "\n";
                msg.append(line);
            }
            if (ok) continue;
            throw new RuntimeException(msg.toString());
        }
    }

    @Test
    public void test_03_InsVep() {
        Gpr.debug("Test");
        this.compareVep("testENST00000268124", "tests/testENST00000268124_ins_vep.vcf", "ENST00000268124");
    }

    @Test
    public void test_04_InsVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3770Chr22", "tests/testENST00000445220_ins_vep.vcf", "ENST00000445220");
    }

    static {
        verbose = debug = false;
    }
}

