/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesHugeDeletions {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-noOut", "testHg3766Chr1", "./tests/huge_deletion_DEL.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.getChromosomeName() + "\t" + ve.getStart() + "\t" + ve.getEnd() + "\tsize:" + ve.size());
            }
            boolean ok = false;
            for (VcfEffect veff : ve.parseEffects()) {
                if (this.verbose) {
                    System.out.println(veff);
                }
                ok |= veff.getEffectType() == EffectType.CHROMOSOME_LARGE_DELETION;
            }
            if (ok) continue;
            Assert.assertTrue("Expecting 'CHROMOSOME_LARGE_DELETION', not found", ok);
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-noOut", "testHg3766Chr1", "./tests/huge_deletion.vcf.gz"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.getChromosomeName() + "\t" + ve.getStart() + "\t" + ve.getInfoStr());
            }
            Assert.assertTrue(ve.getInfo("EFF").startsWith("CHROMOSOME_LARGE_DELETION(HIGH"));
        }
    }
}

