/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.integration.TestCasesHgvsBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesHgvsIntron
extends TestCasesHgvsBase {
    @Test
    public void test_01_intron() {
        Gpr.debug("Test");
        int N = 1000;
        int testIter = -1;
        int testPos = -1;
        int checked = 0;
        int it = 1;
        while (checked < N) {
            this.initSnpEffPredictor(true, false);
            boolean tested = false;
            if (testIter >= 0 && it < testIter) {
                Gpr.debug("Skipping iteration: " + it);
            } else if (this.transcript.introns().size() >= 1) {
                String trstr = this.transcript.toStringAsciiArt(false);
                char[] bases = trstr.toCharArray();
                if (this.verbose) {
                    System.out.println("HGSV Intron\titeration:" + checked + "\t" + (this.transcript.isStrandPlus() ? "+" : "-"));
                    System.out.println(trstr);
                    System.out.println("Length   : " + this.transcript.size());
                    System.out.println("CDS start: " + this.transcript.getCdsStart());
                    System.out.println("CDS end  : " + this.transcript.getCdsEnd());
                    System.out.println(this.transcript);
                } else {
                    Gpr.showMark(it, 1);
                }
                int j = 0;
                for (int pos = this.transcript.getStart(); pos < this.transcript.getEnd(); ++pos) {
                    if (bases[j] == '-') {
                        tested = true;
                        if (testPos >= 0 && pos < testPos) {
                            Gpr.debug("\tSkipping\tpos: " + pos + " [" + j + "]");
                        } else {
                            String refStr = "A";
                            String altStr = "T";
                            String hgsv = this.intronHgsv(bases, j, pos, refStr, altStr);
                            Variant sc = new Variant((Marker)this.transcript.getChromosome(), pos, refStr, altStr, "");
                            VariantEffects ceffs = this.snpEffectPredictor.variantEffect(sc);
                            VariantEffect ceff = ceffs.get();
                            String hgsvEff = ceffs.get().getHgvs();
                            if (this.debug) {
                                System.out.println("\tpos: " + pos + " [" + j + "]\thgsv: '" + hgsv + "'\tEff: '" + hgsvEff + "'\t" + (Object)((Object)ceff.getEffectType()));
                            }
                            if (ceff.getEffectType() == EffectType.INTRON) {
                                Assert.assertEquals(hgsv, hgsvEff);
                            }
                        }
                    }
                    ++j;
                }
                if (tested) {
                    ++checked;
                }
            }
            ++it;
        }
        System.err.println("");
    }
}

