/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesHgvsIns {
    boolean debug;
    boolean verbose;

    public TestCasesHgvsIns() {
        this.verbose = this.debug = false;
    }

    public void checkHgvs(String genome, String vcfFile, int minCheck) {
        List<VcfEntry> list2 = this.snpEffect(genome, vcfFile, null);
        int countCheck = 0;
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            String transcriptId = ve.getInfo("TR");
            if (this.verbose) {
                System.out.println("\tLooking for transcript '" + transcriptId + "'");
            }
            for (VcfEffect veff : ve.parseEffects()) {
                String expectedHgvsP;
                String expectedHgvsC;
                if (!veff.getTranscriptId().equals(transcriptId)) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.p: " + veff.getHgvsP() + "\t\tHGVS.c: " + veff.getHgvsC());
                }
                if ((expectedHgvsC = ve.getInfo("HGVSC")) != null) {
                    String actualHgvsC = veff.getHgvsC();
                    Assert.assertEquals("HGVS.c mismatch", expectedHgvsC, actualHgvsC);
                    ++countCheck;
                }
                if ((expectedHgvsP = ve.getInfo("HGVSP")) == null) continue;
                String actualHgvsP = veff.getHgvsP();
                Assert.assertEquals("HGVS.p mismatch", expectedHgvsP, actualHgvsP);
                ++countCheck;
            }
        }
        if (this.verbose) {
            System.out.println("Total checked: " + countCheck);
        }
        Assert.assertTrue("Too few variants checked: " + countCheck, countCheck >= minCheck);
    }

    public List<VcfEntry> snpEffect(String genome, String vcfFile, String[] otherArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (otherArgs != null) {
            for (String a : otherArgs) {
                args.add(a);
            }
        }
        args.add(genome);
        args.add(vcfFile);
        SnpEff cmd = new SnpEff(args.toArray(new String[0]));
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        cmdEff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        Assert.assertFalse("Annotation finished with errors", cmdEff.getTotalErrs() > 0);
        return list2;
    }

    @Test
    public void test_02_hgvs_insertions_chr1() {
        Gpr.debug("Test");
        this.checkHgvs("testHg19Chr1", "tests/hgvs_ins_dups_chr1.vcf", 4);
    }

    @Test
    public void test_03_hgvs_insertions_chr3() {
        Gpr.debug("Test");
        this.checkHgvs("testHg19Chr3", "tests/hgvs_ins_dups_chr3.vcf", 2);
    }

    @Test
    public void test_04_hgvs_insertions_chr4() {
        Gpr.debug("Test");
        this.checkHgvs("testHg19Chr4", "tests/hgvs_ins_dups_chr4.vcf", 2);
    }

    @Test
    public void test_05_hgvs_insertions_chr19() {
        Gpr.debug("Test");
        this.checkHgvs("testHg19Chr19", "tests/hgvs_ins_dups_chr19.vcf", 2);
    }

    @Test
    public void test_06_hgvs_insertions_chr7() {
        Gpr.debug("Test");
        this.checkHgvs("testHg19Chr7", "tests/hgvs_ins_chr7.vcf", 2);
    }

    @Test
    public void test_07_hgvs_insertions1() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/hgvs_ins_07.vcf";
        this.snpEffect(genomeName, vcf, null);
    }
}

